const mix = require('laravel-mix');
/*
 |--------------------------------------------------------------------------
 | Mix Asset Management
 |--------------------------------------------------------------------------
 |
 | Mix provides a clean, fluent API for defining some Webpack build steps
 | for your Laravel application. By default, we are compiling the Sass
 | file for the application as well as bundling up all the JS files.
 |
 */


mix.options({
    purifyCss: {
        purifyOptions: {
            whitelist: ['*animat*', '*hinge*', '*owl*', '*navbar*', '*fade*', '*img-change*', '*raz*', '*dva*' , '#scrollUp']
        }
    }
});

mix.js('resources/js/app.js', 'public/js')
    .scripts([
        'resources/assets/site/js/vendor/modernizr-3.6.0.min.js',
        'resources/assets/site/js/vendor/jquery-3.3.1.min.js',
        'resources/assets/site/js/vendor/popper.js',
        'resources/assets/site/js/vendor/bootstrap.min.js',
        'resources/assets/site/js/plugins/countdown.js',
        'resources/assets/site/js/plugins/counterup.js',
        'resources/assets/site/js/plugins/images-loaded.js',
        'resources/assets/site/js/plugins/isotope.js',
        'resources/assets/site/js/plugins/instafeed.js',
        'resources/assets/site/js/plugins/jquery-ui.js',
        'resources/assets/site/js/plugins/jquery-ui-touch-punch.js',
        'resources/assets/site/js/plugins/magnific-popup.js',
        'resources/assets/site/js/plugins/owl-carousel.js',
        'resources/assets/site/js/plugins/scrollup.js',
        'resources/assets/site/js/plugins/waypoints.js',
        'resources/assets/site/js/plugins/slick.js',
        'resources/assets/site/js/plugins/wow.js',
        'resources/assets/site/js/plugins/textillate.js',
        'resources/assets/site/js/plugins/elevatezoom.js',
        'resources/assets/site/js/plugins/sticky-sidebar.js',
        'resources/assets/site/js/plugins/smoothscroll.js',
        'resources/assets/site/js/main.js',
        'public/js/app.js'
    ],  'public/js/full.js')
    .sass('resources/sass/app.scss', 'public/css')
    .styles([
        'public/css/app.css',
        'resources/assets/site/css/vendor/bootstrap.min.css',
        'resources/assets/site/css/vendor/line-awesome.css',
        'resources/assets/site/css/vendor/themify.css',
        'resources/assets/site/css/plugins/animate.css',
        'resources/assets/site/css/plugins/owl-carousel.css',
        'resources/assets/site/css/plugins/slick.css',
        'resources/assets/site/css/plugins/magnific-popup.css',
        'resources/assets/site/css/plugins/jquery-ui.css',
        'resources/assets/site/css/style.css'
    ],  'public/css/full.css');

/*mix.js('resources/js/app-admin.js', 'public/js')
    .scripts([
        'resources/assets/admin/vendor_components/jquery/dist/jquery.js',
        'resources/assets/admin/vendor_components/jquery-ui/jquery-ui.js',
        'resources/assets/admin/vendor_components/popper/dist/popper.min.js',
        'resources/assets/admin/vendor_components/bootstrap/dist/js/bootstrap.js',
        'resources/assets/admin/vendor_components/chart.js-master/Chart.min.js',
        'resources/assets/admin/vendor_components/jquery-slimscroll/jquery.slimscroll.js',
        'resources/assets/admin/vendor_components/fastclick/lib/fastclick.js',
        'resources/assets/admin/vendor_components/jquery.peity/jquery.peity.js',
        'resources/assets/admin/vendor_components/raphael/raphael.min.js',
        'resources/assets/admin/vendor_components/morris.js/morris.min.js',
        'resources/assets/admin/vendor_components/jvectormap/lib2/jquery-jvectormap-2.0.2.min.js',
        'resources/assets/admin/vendor_components/jvectormap/lib2/jquery-jvectormap-world-mill-en.js',
        'resources/assets/admin/vendor_components/jvectormap/lib2/jquery-jvectormap-us-aea-en.js',
        'resources/assets/admin/js/template.js',
        'resources/assets/admin/js/demo.js',
        'resources/assets/admin/js/horizontal-layout.js',
        'resources/assets/admin/js/pages/validation.js',
        'public/js/app-admin.js'
    ],  'public/js/full-admin.js')
    .sass('resources/sass/app-admin.scss', 'public/css')
    .styles([
        'resources/assets/admin/vendor_components/bootstrap/dist/css/bootstrap.css',
        'resources/assets/admin/css/bootstrap-extend.css',
        'resources/assets/admin/vendor_components/fontawesome-free-5.9.0-web/css/all.css',
        'resources/assets/admin/vendor_components/Ionicons/css/ionicons.css',
        'resources/assets/admin/vendor_components/themify-icons/css/themify-icons.css',
        'resources/assets/admin/vendor_components/linea-icons/css/linea.css',
        'resources/assets/admin/vendor_components/glyphicons/css/glyphicon.css',
        'resources/assets/admin/vendor_components/flag-icon/css/flag-icon.css',
        'resources/assets/admin/vendor_components/material-design-iconic-font/css/materialdesignicons.css',
        'resources/assets/admin/vendor_components/simple-line-icons-master/css/simple-line-icons.css',
        'resources/assets/admin/css/iconfont/css/style.css',
        'resources/assets/admin/css/master_style.css',
        'resources/assets/admin/css/horizontal_menu_style.css',
        'resources/assets/admin/css/skins/_all-skins.css',
        'resources/assets/admin/vendor_components/jvectormap/lib2/jquery-jvectormap-2.0.2.css',
        'resources/assets/admin/vendor_components/morris.js/morris.css',
        'public/css/app-admin.css'
    ],  'public/css/full-admin.css');*/
