        <!-- Text Wrapper. Contains page content -->
    <section class="content-wrapper">
        <!-- Text Header (Page header) -->
        <section class="content-header">
            <h1>
                Список товаров
            </h1>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/admin"><i class="fa fa-dashboard"></i> Главная</a></li>
                <li class="breadcrumb-item active">Товары</li>
                <li class="breadcrumb-item active">Список товаров</li>
            </ol>
        </section>

        <!-- Main content -->
        <section class="content pb-15">
            <div class="row">
                <div class="col-md-12">
                    <?php if(session()->has('flash_message')): ?>
                        <div class="alert alert-success alert-dismissible alert-save">
                            <?php echo e(session()->get('flash_message')); ?>

                        </div>
                    <?php endif; ?>
                </div>
                <div class="col-md-12">
                    <div class="box">
                        <div class="box-header with-border">
                            <h4 class="box-title">Форма для редактирования или удаления товаров</h4>
                        </div>
                        <div class="row">
                            <div class="col-md-4">

                            </div>
                            <div class="col-md-4">
                                <div class="mt-20 mr-20">
                                    <form action="/admin/products">
                                        <input placeholder="Поиск" class="nice-select form-control ml-auto" name="search" style="width: 100% !important;">
                                    </form>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mt-20 mr-20">
                                    <form action="/admin/products">
                                        <select class="nice-select form-control ml-auto" name="sort" style="width: 100% !important;">
                                            <option value="all" <?php if($sort == 'all'): ?> selected <?php endif; ?>>Все производители товаров</option>
                                            <?php if(isset($manufactures)): ?>
                                                <?php $__currentLoopData = $manufactures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo $item->id; ?>" <?php if($sort == $item->id): ?> selected <?php endif; ?>>- <?php echo $item->name; ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </select>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="box-body">
                            <div class="table-responsive">
                                <table id="tickets" class="table mt-0 table-hover no-wrap table-striped table-bordered" data-page-size="10">
                                    <thead>
                                        <tr class="bg-dark">
                                            <th class="text-center">ID #</th>
                                            <th>Название товара</th>
                                            <th>Производители</th>
                                            <th>Тип</th>
                                            <th>Наличие</th>
                                            <th class="text-center" style="min-width: 130px;">Действия</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if(isset($products)): ?>
                                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td class="text-center">
                                                        <?php echo $item->id; ?>

                                                    </td>
                                                    <td>
                                                        <a href="/admin/products/<?php echo $item->id; ?>" class="mx-5" data-toggle="tooltip" data-original-title="Редактировать">
                                                            <?php echo $item->title; ?>

                                                        </a>
                                                    </td>
                                                    <td>
                                                        <?php echo $item->manufactures->name; ?>

                                                    </td>
                                                    <td>
                                                         <?php echo $item->typs->name; ?>

                                                    </td>
                                                    <td>
                                                         <?php if($item->stocks->name == 'on'): ?>
                                                            В наличии
                                                         <?php else: ?>
                                                            Нет в наличии
                                                        <?php endif; ?>
                                                    </td>
                                                    <td class="text-center">
                                                        <form id="form-del-<?php echo $item->id; ?>" class="settings inline" method="post" action="/admin/products">
                                                            <?php echo csrf_field(); ?>
                                                            <input type="text" name="status" value="del" hidden>
                                                            <input type="text" name="productID" value="<?php echo $item->id; ?>" hidden>
                                                            <button type="submit" class="btn btn-sm btn-danger-outline mx-5" data-toggle="tooltip" data-original-title="Удалить">
                                                                <i class="ti-trash" aria-hidden="true"></i>
                                                            </button>
                                                        </form>
                                                        <div class="inline">
                                                            <a href="/admin/products/<?php echo $item->id; ?>" class="btn btn-sm btn-success-outline mx-5" data-toggle="tooltip" data-original-title="Редактировать">
                                                                <i class="ti-pencil" aria-hidden="true"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <?php if(isset($products)): ?>
                        <?php if($products->lastPage() > 1): ?>
                            <nav class="pb-20">
                                <ul class="pagination justify-content-center">
                                    <?php if($products->currentPage() == 1): ?>
                                        <li class="page-item disabled"><a class="page-link" href="#"><span class="ion-ios-arrow-thin-left"></span></a></li>
                                    <?php else: ?>
                                        <li class="page-item"><a class="page-link" href="<?php echo $products->url(($products->currentPage() - 1)); ?>"><span class="ion-ios-arrow-thin-left"></span></a></li>
                                    <?php endif; ?>
                                    <?php if($products->currentPage() - 5 >= 1): ?>
                                        <li class="page-item"><a class="page-link" href="<?php echo $products->url(1); ?>">...</a></li>
                                    <?php endif; ?>
                                    <?php for($i = 1; $i <= $products->lastPage(); $i++): ?>
                                        <?php if($i >= ($products->currentPage() + 5) || $i <= ($products->currentPage() - 5)): ?>
                                        <?php elseif($products->currentPage() == $i): ?>
                                            <li class="page-item active"><a href="javascript:void(0)" class="page-link"><?php echo $i; ?></a></li>
                                        <?php else: ?>
                                            <li  class="page-item"><a href="<?php echo $products->url($i); ?>" class="page-link"><?php echo $i; ?></a></li>
                                        <?php endif; ?>
                                    <?php endfor; ?>
                                    <?php if($products->currentPage() + 5 <= $products->lastPage()): ?>
                                        <li class="page-item"><a class="page-link" href="<?php echo $products->url(($products->lastPage())); ?>">...</a></li>
                                    <?php endif; ?>
                                    <?php if($products->currentPage() !== $products->lastPage()): ?>
                                        <li class="page-item "><a class="page-link" href="<?php echo $products->url(($products->currentPage() + 1)); ?>"><span class="ion-ios-arrow-thin-right"></span></a></li>
                                    <?php else: ?>
                                        <li class="page-item disabled"><a class="page-link" href="#"><span class="ion-ios-arrow-thin-right"></span></a></li>
                                    <?php endif; ?>
                                </ul>
                            </nav>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
            <a href="/admin/products/create" class="btn btn-primary btn-lg btn-block py-5 mb-4">Добавить новый товар</a>
        </section>
    </section>
