    <script src="<?php echo e(asset('/js/ckeditor/ckeditor.js')); ?>" type="text/javascript" charset="utf-8" ></script>
    <!-- Text Wrapper. Contains page content -->
    <section class="content-wrapper">
        <!-- Text Header (Page header) -->
        <section class="content-header">
            <h1>
                <?php echo e($article->h1); ?>

            </h1>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/admin"><i class="fa fa-dashboard"></i> Главная</a></li>
                <li class="breadcrumb-item active"><a href="/admin/articles">Статьи</a></li>
                <li class="breadcrumb-item active"><?php echo e($article->h1); ?></li>
            </ol>
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-solid bg-dark">
                        <div class="box-header with-border">
                            <h4 class="box-title">Форма редактирования статьи</h4>
                            <h6 class="box-subtitle">Внесите соответствующие изменения и нажмите кнопку <span class="text-warning">Сохранить</span></h6>
                            <ul class="box-controls pull-right">
                                <li><a class="box-btn-close" href="#"></a></li>
                                <li><a class="box-btn-slide" href="#"></a></li>
                                <li><a class="box-btn-fullscreen" href="#"></a></li>
                            </ul>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            <div class="row">
                                <div class="col">
                                    <form id="form-save-1" class="settings" method="post" action="/admin/manufacture">
                                        <?php echo csrf_field(); ?>
                                        <input type="text" name="status" value="edit" hidden>
                                        <input type="text" name="articleID" value="<?php echo $article->id; ?>" hidden>
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <div class="form-group" hidden>
                                                    <h5>Категория статей<span class="text-danger">*</span></h5>
                                                    <select class=" form-control" name="categoryID">
                                                        <option value="4" selected>Статьи</option>
                                                    </select>
                                                </div>
                                                <div class="form-group" hidden>
                                                    <h5>Seo URL<span class="text-danger">*</span></h5>
                                                    <div class="controls">
                                                        <input type="text" name="alias" class="form-control" value="<?php echo e($article->alias); ?>">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <h5>SEO Заголовок<span class="text-danger">*</span></h5>
                                                    <div class="controls">
                                                        <input type="text" name="title" class="form-control" required data-validation-required-message="This field is required" minlength="10" maxlength="90" placeholder="Оптимальная длина title варьируется от 10 до 90 символов" value="<?php echo e($article->title); ?>">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <h5>SEO Описание<span class="text-danger">*</span></h5>
                                                    <div class="controls">
                                                        <input type="text" name="description" class="form-control" required data-validation-required-message="This field is required" minlength="50" maxlength="300" placeholder="Оптимальная длина description варьируется от 50 до 300 символов" value="<?php echo e($article->description); ?>">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <h5>Заголовок h1<span class="text-danger">*</span></h5>
                                                    <div class="controls">
                                                        <input type="text" name="h1" class="form-control" value="<?php echo e($article->h1); ?>">
                                                    </div>
                                                </div>
                                                <div class="form-group" hidden>
                                                    <h5>Изображение для предпросмотра<span class="text-danger">*</span></h5>
                                                    <div class="controls">
                                                        <textarea name="img" id="editor4" name="editor4"><img src="<?php echo e($article->img); ?>" alt=""></textarea>
                                                    </div>
                                                </div>
                                                <div class="form-group" hidden>
                                                    <h5>Краткое описание статьи<span class="text-danger">*</span></h5>
                                                    <div class="controls">
                                                        <textarea name="text1" style="width: 100%; height: 80px;"><?php echo e($article->text1); ?></textarea>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <h5>Основной текст статьи<span class="text-danger">*</span></h5>
                                                    <div class="controls">
                                                        <textarea name="text2" id="editor3" name="editor3"><?php echo e($article->text2); ?></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="text-xs-right">
                                            <button type="submit" class="btn btn-info " data-id="1">Сохранить</button>
                                            <a href="/admin/manufacture" class="btn btn-info ">Отменить</a>
                                        </div>
                                    </form>

                                </div>
                                <!-- /.col -->
                            </div>
                            <!-- /.row -->
                        </div>
                        <!-- /.box-body -->
                    </div>
                    <!-- /.box -->
                </div>
            </div>
        </section>
    </section>
    <script>let editor1 = CKEDITOR.replace( 'editor1' );</script>
    <script>let editor2 = CKEDITOR.replace( 'editor2' );</script>
    <script>let editor3 = CKEDITOR.replace( 'editor3' );</script>
    <script>let editor4 = CKEDITOR.replace( 'editor4', {toolbar: [{ name: 'insert', items: [ 'Image'] },]});</script>
