    <!-- Text Wrapper. Contains page content -->
    <section class="content-wrapper">
        <!-- Text Header (Page header) -->
        <section class="content-header">
            <h1>
                Настройки сайта
            </h1>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/admin"><i class="fa fa-dashboard"></i> Главная</a></li>
                <li class="breadcrumb-item active">Настройки сайта</li>
            </ol>
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <?php if(session()->has('flash_message')): ?>
                        <div class="alert alert-success alert-dismissible alert-save">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            <h4><i class="icon fa fa-check"></i> Сообщение!</h4>
                            <?php echo e(session()->get('flash_message')); ?>

                        </div>
                    <?php endif; ?>
                    <?php if(session()->has('flash_message_error')): ?>
                        <div class="alert alert-danger alert-err alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            <h4><i class="icon fa fa-ban"></i> Сообщение!</h4>
                            <?php echo e(session()->get('flash_message_error')); ?>

                        </div>
                    <?php endif; ?>
                </div>
                <div class="col-md-6">
                    <div class="box box-solid bg-dark">
                        <div class="box-header with-border">
                            <h4 class="box-title">Настройки Администратора</h4>
                            <h6 class="box-subtitle">Внесите соответствующие изменения и нажмите кнопку <span class="text-warning">Сохранить</span></h6>
                            <ul class="box-controls pull-right">
                                <li><a class="box-btn-close" href="#"></a></li>
                                <li><a class="box-btn-slide" href="#"></a></li>
                                <li><a class="box-btn-fullscreen" href="#"></a></li>
                            </ul>
                        </div>
                        <div class="box-body">
                            <div class="row">
                                <div class="col">
                                    <form id="form-save-1" class="settings" method="post" action="/admin/settings">
                                        <?php echo csrf_field(); ?>
                                        <input type="text" name="status" value="admin" hidden>
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <div class="form-group">
                                                    <h5>Ваш Email<span class="text-danger">*</span></h5>
                                                    <div class="controls">
                                                        <input type="email" name="email" class="form-control" required data-validation-required-message="This field is required" value="<?php echo e($admin->email); ?>">
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <h5>Ваш Пароль <span class="text-danger">*</span></h5>
                                                    <div class="controls">
                                                        <input type="password" name="password" class="form-control" required data-validation-required-message="This field is required"> </div>
                                                </div>
                                                <div class="form-group">
                                                    <h5>Повторить пароль <span class="text-danger">*</span></h5>
                                                    <div class="controls">
                                                        <input type="password" name="password2" data-validation-match-match="password" class="form-control" required> </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="text-xs-right">
                                            <button type="submit" class="btn btn-info" data-id="1">Сохранить</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="box box-solid bg-dark">
                        <div class="box-header with-border">
                            <h4 class="box-title">Настройки Google Analytics</h4>
                            <h6 class="box-subtitle">Вставьте код Google Analytics и <span class="text-warning">сохраните</span> изменения</h6>
                            <ul class="box-controls pull-right">
                                <li><a class="box-btn-close" href="#"></a></li>
                                <li><a class="box-btn-slide" href="#"></a></li>
                                <li><a class="box-btn-fullscreen" href="#"></a></li>
                            </ul>
                        </div>
                        <div class="box-body">
                            <div class="row">
                                <div class="col">
                                    <form id="form-save-2" class="settings" method="post" action="/admin/settings">
                                        <?php echo csrf_field(); ?>
                                        <input type="text" name="status" value="google_analytics" hidden>
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <div class="form-group">
                                                    <h5>Код Google Analytics <span class="text-danger">*</span></h5>
                                                    <div class="controls">
                                                        <textarea name="google_analytics" id="textarea" rows="5" class="form-control" required placeholder="Вставьте код Google Analytics"><?php echo $settings->google_analytics; ?></textarea>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <h5>Адресс сайта<span class="text-danger">*</span></h5>
                                                    <div class="controls">
                                                        <input name="site"  class="form-control" value="<?php echo $settings->site; ?>">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="text-xs-right">
                                            <button type="submit" class="btn btn-info">Сохранить</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="box box-solid bg-dark">
                        <div class="box-header with-border">
                            <h4 class="box-title">Настройки ToLike</h4>
                            <h6 class="box-subtitle">Вставьте код и <span class="text-warning">сохраните</span> изменения</h6>
                            <ul class="box-controls pull-right">
                                <li><a class="box-btn-close" href="#"></a></li>
                                <li><a class="box-btn-slide" href="#"></a></li>
                                <li><a class="box-btn-fullscreen" href="#"></a></li>
                            </ul>
                        </div>
                        <div class="box-body">
                            <div class="row">
                                <div class="col">
                                    <form id="form-save-3" class="settings" method="post" action="/admin/settings">
                                        <?php echo csrf_field(); ?>
                                        <input type="text" name="status" value="like" hidden>
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <div class="form-group">
                                                    <h5>Ваш код <span class="text-danger">*</span></h5>
                                                    <div class="controls">
                                                        <textarea name="like" id="textarea" rows="5" class="form-control" required placeholder="Вставьте код"><?php echo $settings->like; ?></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="text-xs-right">
                                            <button type="submit" class="btn btn-info">Сохранить</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="box box-solid bg-dark">
                        <div class="box-header with-border">
                            <h4 class="box-title">Настройки комментариев</h4>
                            <h6 class="box-subtitle">Вставьте код и <span class="text-warning">сохраните</span> изменения</h6>
                            <ul class="box-controls pull-right">
                                <li><a class="box-btn-close" href="#"></a></li>
                                <li><a class="box-btn-slide" href="#"></a></li>
                                <li><a class="box-btn-fullscreen" href="#"></a></li>
                            </ul>
                        </div>
                        <div class="box-body">
                            <div class="row">
                                <div class="col">
                                    <form id="form-save-4" class="settings" method="post" action="/admin/settings">
                                        <?php echo csrf_field(); ?>
                                        <input type="text" name="status" value="comments" hidden>
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <div class="form-group">
                                                    <h5>Код комментариев <span class="text-danger">*</span></h5>
                                                    <div class="controls">
                                                        <textarea name="comments" id="textarea" rows="5" class="form-control" required placeholder="Вставьте код "><?php echo $settings->comments; ?></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="text-xs-right">
                                            <button type="submit" class="btn btn-info">Сохранить</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </section>
