<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Auth::routes();

// BackEnd
Route::group(['prefix' => 'admin', 'middleware' => ['auth']], function () {
    Route::resource('/', 'BackEnd\HomeController')->only(['index', 'store']);
    Route::resource('/faq', 'BackEnd\FaqController')->only(['index', 'store']);
    Route::resource('/settings', 'BackEnd\SettingsController')->only(['index', 'store']);
    Route::resource('/content', 'BackEnd\ContentController')->only(['index', 'store']);
    Route::resource('/fm', 'BackEnd\FmController')->only(['index']);
    Route::resource('/products', 'BackEnd\ProductsController')->only(['index', 'store', 'show', 'create']);
    Route::resource('/price', 'BackEnd\PriceController')->only(['index', 'store']);
    Route::resource('/category', 'BackEnd\CategoryController')->only(['index', 'store', 'show', 'create']);
    Route::resource('/articles', 'BackEnd\ArticlesController')->only(['index', 'store', 'show', 'create']);
    Route::resource('/manufacture', 'BackEnd\ManufactureController')->only(['index', 'store', 'show']);
    Route::resource('/comments', 'BackEnd\CommentsController')->only(['index', 'store']);
    Route::resource('/messages', 'BackEnd\MessagesController')->only(['index', 'store', 'show']);
    Route::resource('/orders', 'BackEnd\OrderController')->only(['index', 'store', 'show']);
    Route::resource('/users', 'BackEnd\UsersController')->only(['index', 'store']);
});

// PARSER
Route::resource('/pars', 'BackEnd\ParserController')->only(['index']);

// FrontEnd
Route::get('/', 'FrontEnd\PageController@index');
Route::resource('/search', 'FrontEnd\PageController')->only(['store']);
Route::get('/about', 'FrontEnd\PageController@index');
Route::get('/partner', 'FrontEnd\PageController@index');
Route::get('/application-1', 'FrontEnd\PageController@index');
Route::get('/application-2', 'FrontEnd\PageController@index');
Route::get('/application-3', 'FrontEnd\PageController@index');
Route::get('/application-4', 'FrontEnd\PageController@index');
Route::resource('/news', 'FrontEnd\BlogController')->only(['index', 'show']);
Route::resource('/contact', 'FrontEnd\ContactController')->only(['index', 'store']);
/*Route::resource('/manufacture', 'FrontEnd\ManufactureController')->only(['show']);*/
Route::get('/clear', function() {Artisan::call('cache:clear'); Artisan::call('config:clear'); Artisan::call('config:cache'); return 'кеш очищен <br> <a href="/">Вернуться на главную</a>';});
Route::get('/{category}', 'FrontEnd\CategoriesController@index');
Route::get('/{category}/{alias}', 'FrontEnd\CategoriesController@show');
