    <!-- Text Wrapper. Contains page content -->
    <section class="content-wrapper">
        <!-- Text Header (Page header) -->
        <section class="content-header">
            <h1>
                Пользователи
            </h1>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/admin"><i class="fa fa-dashboard"></i> Главная</a></li>
                <li class="breadcrumb-item active">Пользователи</li>
            </ol>
        </section>

        <!-- Main content -->
        <section class="content pb-15">
            <div class="row">
                <div class="col-md-12">
                    @if(session()->has('flash_message_user'))
                        <div class="alert alert-success alert-dismissible alert-save">
                            {{ session()->get('flash_message_user') }}
                        </div>
                    @endif
                </div>
                <div class="col-md-12">
                    <div class="box">
                        <div class="box-header with-border">
                            <h4 class="box-title">Форма для редактирования привилегий пользователей</h4>
                        </div>
                        <div class="box-body">
                            <div class="table-responsive">
                                <form action="/admin/users" method="post">
                                    @csrf
                                    <table id="tickets" class="table mt-0 table-hover no-wrap table-striped table-bordered" data-page-size="10">
                                        <thead>
                                        <tr class="bg-dark">
                                            <th class="text-center">ID #</th>
                                            <th>Имя пользователя</th>
                                            <th>Email пользователя</th>
                                            <th class="text-center">Сумма оплаченых заказов</th>
                                            <th class="text-center">Привилегии пользователя</th>
                                            <th class="text-center">Удалить</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @isset($users)
                                            @foreach($users as $item)
                                                <tr>
                                                    <td class="text-center">
                                                        {!! $item->id !!}
                                                        <input type="text" name="userID[]" value="{!! $item->id !!}" hidden>
                                                    </td>
                                                    <td>
                                                        {!! $item->name !!}
                                                    </td>
                                                    <td>
                                                        {!! $item->email !!}
                                                    </td>
                                                    <td class="text-center">
                                                        {!! $item->order_total !!} грн
                                                    </td>
                                                    <td class="text-center">
                                                        <select name="role[]" class="form-control">
                                                            <option value="1" @if(!isset($item->roles->first()->name) OR $item->roles->first()->name == 'user') selected @endif>Обычнй пользователь</option>
                                                            <option value="4" @if($item->roles->first()->name == 'user10') selected @endif>10% скидка</option>
                                                            <option value="5" @if($item->roles->first()->name == 'user15') selected @endif>15% скидка</option>
                                                            <option value="6" @if($item->roles->first()->name == 'user20') selected @endif>20% скидка</option>
                                                            <option value="7" @if($item->roles->first()->name == 'user25') selected @endif>25% скидка</option>
                                                            <option value="8" @if($item->roles->first()->name == 'user30') selected @endif>30% скидка</option>
                                                            <option value="3" @if($item->roles->first()->name == 'admin') selected @endif>Супер пользователь</option>
                                                        </select>
                                                    </td>
                                                    <td  class="text-center">
                                                        @if($item->id != 1)
                                                            <a href="/admin/users/?trash={!! $item->id !!}" class="mx-5" data-toggle="tooltip" data-original-title="Удалить">
                                                                <button type="button" class="btn btn-sm btn-danger-outline" data-toggle="tooltip" data-original-title="Delete"><i class="ti-trash" aria-hidden="true"></i></button>
                                                            </a>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endisset
                                        </tbody>
                                    </table>
                                    <button type="submit" class="btn btn-primary btn-lg btn-block py-5 mb-4">Сохранить изменения</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </section>
