        <!-- Text Wrapper. Contains page content -->
    <section class="content-wrapper">
        <!-- Text Header (Page header) -->
        <section class="content-header">
            <h1>
                Список товаров
            </h1>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/admin"><i class="fa fa-dashboard"></i> Главная</a></li>
                <li class="breadcrumb-item active">Товары</li>
                <li class="breadcrumb-item active">Список товаров</li>
            </ol>
        </section>

        <!-- Main content -->
        <section class="content pb-15">
            <div class="row">
                <div class="col-md-12">
                    @if(session()->has('flash_message'))
                        <div class="alert alert-success alert-dismissible alert-save">
                            {{ session()->get('flash_message') }}
                        </div>
                    @endif
                </div>
                <div class="col-md-12">
                    <div class="box">
                        <div class="box-header with-border">
                            <h4 class="box-title">Форма для редактирования или удаления товаров</h4>
                        </div>
                        <div class="row">
                            <div class="col-md-4">

                            </div>
                            <div class="col-md-4">
                                <div class="mt-20 mr-20">
                                    <form action="/admin/products">
                                        <input placeholder="Поиск" class="nice-select form-control ml-auto" name="search" style="width: 100% !important;">
                                    </form>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mt-20 mr-20">
                                    <form action="/admin/products">
                                        <select class="nice-select form-control ml-auto" name="sort" style="width: 100% !important;">
                                            <option value="all" @if($sort == 'all') selected @endif>Все производители товаров</option>
                                            @isset($manufactures)
                                                @foreach($manufactures as $item)
                                                    <option value="{!! $item->id !!}" @if($sort == $item->id) selected @endif>- {!! $item->name !!}</option>
                                                @endforeach
                                            @endisset
                                        </select>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="box-body">
                            <div class="table-responsive">
                                <table id="tickets" class="table mt-0 table-hover no-wrap table-striped table-bordered" data-page-size="10">
                                    <thead>
                                        <tr class="bg-dark">
                                            <th class="text-center">ID #</th>
                                            <th>Название товара</th>
                                            <th>Производители</th>
                                            <th>Тип</th>
                                            <th>Наличие</th>
                                            <th class="text-center" style="min-width: 130px;">Действия</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @isset($products)
                                            @foreach($products as $item)
                                                <tr>
                                                    <td class="text-center">
                                                        {!! $item->id !!}
                                                    </td>
                                                    <td>
                                                        <a href="/admin/products/{!! $item->id !!}" class="mx-5" data-toggle="tooltip" data-original-title="Редактировать">
                                                            {!! $item->title !!}
                                                        </a>
                                                    </td>
                                                    <td>
                                                        {!! $item->manufactures->name !!}
                                                    </td>
                                                    <td>
                                                         {!! $item->typs->name !!}
                                                    </td>
                                                    <td>
                                                         @if($item->stocks->name == 'on')
                                                            В наличии
                                                         @else
                                                            Нет в наличии
                                                        @endif
                                                    </td>
                                                    <td class="text-center">
                                                        <form id="form-del-{!! $item->id !!}" class="settings inline" method="post" action="/admin/products">
                                                            @csrf
                                                            <input type="text" name="status" value="del" hidden>
                                                            <input type="text" name="productID" value="{!! $item->id !!}" hidden>
                                                            <button type="submit" class="btn btn-sm btn-danger-outline mx-5" data-toggle="tooltip" data-original-title="Удалить">
                                                                <i class="ti-trash" aria-hidden="true"></i>
                                                            </button>
                                                        </form>
                                                        <div class="inline">
                                                            <a href="/admin/products/{!! $item->id !!}" class="btn btn-sm btn-success-outline mx-5" data-toggle="tooltip" data-original-title="Редактировать">
                                                                <i class="ti-pencil" aria-hidden="true"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endisset
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    @isset($products)
                        @if($products->lastPage() > 1)
                            <nav class="pb-20">
                                <ul class="pagination justify-content-center">
                                    @if($products->currentPage() == 1)
                                        <li class="page-item disabled"><a class="page-link" href="#"><span class="ion-ios-arrow-thin-left"></span></a></li>
                                    @else
                                        <li class="page-item"><a class="page-link" href="{!! $products->url(($products->currentPage() - 1)) !!}"><span class="ion-ios-arrow-thin-left"></span></a></li>
                                    @endif
                                    @if($products->currentPage() - 5 >= 1)
                                        <li class="page-item"><a class="page-link" href="{!! $products->url(1) !!}">...</a></li>
                                    @endif
                                    @for($i = 1; $i <= $products->lastPage(); $i++)
                                        @if($i >= ($products->currentPage() + 5) || $i <= ($products->currentPage() - 5))
                                        @elseif($products->currentPage() == $i)
                                            <li class="page-item active"><a href="javascript:void(0)" class="page-link">{!! $i !!}</a></li>
                                        @else
                                            <li  class="page-item"><a href="{!! $products->url($i) !!}" class="page-link">{!! $i !!}</a></li>
                                        @endif
                                    @endfor
                                    @if($products->currentPage() + 5 <= $products->lastPage())
                                        <li class="page-item"><a class="page-link" href="{!! $products->url(($products->lastPage())) !!}">...</a></li>
                                    @endif
                                    @if($products->currentPage() !== $products->lastPage())
                                        <li class="page-item "><a class="page-link" href="{!! $products->url(($products->currentPage() + 1)) !!}"><span class="ion-ios-arrow-thin-right"></span></a></li>
                                    @else
                                        <li class="page-item disabled"><a class="page-link" href="#"><span class="ion-ios-arrow-thin-right"></span></a></li>
                                    @endif
                                </ul>
                            </nav>
                        @endif
                    @endisset
                </div>
            </div>
            <a href="/admin/products/create" class="btn btn-primary btn-lg btn-block py-5 mb-4">Добавить новый товар</a>
        </section>
    </section>
