    <!-- Text Wrapper. Contains page content -->
    <section class="content-wrapper">
        <!-- Text Header (Page header) -->
        <section class="content-header">
            <h1>
                Список товаров
            </h1>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/admin"><i class="fa fa-dashboard"></i> Главная</a></li>
                <li class="breadcrumb-item active">Товары</li>
                <li class="breadcrumb-item active">Список товаров</li>
            </ol>
        </section>

        <!-- Main content -->
        <section class="content pb-15">
            <div class="row">
                <div class="col-md-12">
                    @if(session()->has('flash_message'))
                        <div class="alert alert-success alert-dismissible alert-save">
                            {{ session()->get('flash_message') }}
                        </div>
                    @endif
                </div>


                <div class="col-md-12">
                    <div class="box">
                        <div class="box-header with-border">
                            <h4 class="box-title">Форма для редактирования избранных товаров</h4>
                        </div>
                        <div class="box-body">
                            <div class="table-responsive">
                                <form action="/admin/price" method="post">
                                    @csrf
                                    <table id="tickets" class="table mt-0 table-hover no-wrap table-striped table-bordered" data-page-size="10">
                                        <thead>
                                        <tr class="bg-dark">
                                            <th class="text-center">ID #</th>
                                            <th>Название товара</th>
                                            <th>Категория товара</th>
                                            <th class="text-center">Цена</th>
                                            <th class="text-center">Статус</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @isset($productsTop)
                                            @foreach($productsTop as $item)
                                                <tr>
                                                    <td class="text-center">
                                                        {!! $item->id !!}
                                                        <input type="text" name="productID[]" value="{!! $item->id !!}" hidden>
                                                    </td>
                                                    <td>
                                                        <a href="/admin/products/{!! $item->id !!}" class="mx-5" data-toggle="tooltip" data-original-title="Редактировать">
                                                            {!! $item->title !!}
                                                        </a>
                                                    </td>
                                                    <td>
                                                        {!! $item->category->name !!}
                                                    </td>
                                                    <td class="text-center">
                                                        <input name="price[]" type="text" value="{!! $item->price !!}">
                                                    </td>
                                                    <td class="text-center">
                                                        <select name="statusID[]" class="form-control">
                                                            <option value="0" @if($item->status == 0) selected @endif>Обычнй товар</option>
                                                            <option value="1" @if($item->status == 1) selected @endif>Избранный товар №1</option>
                                                            <option value="2" @if($item->status == 2) selected @endif>Избранный товар №2</option>
                                                            <option value="3" @if($item->status == 3) selected @endif>Избранный товар №3</option>
                                                            <option value="4" @if($item->status == 4) selected @endif>Избранный товар №4</option>
                                                            <option value="5" @if($item->status == 5) selected @endif>Товара нет в наличии</option>
                                                        </select>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endisset
                                        </tbody>
                                    </table>
                                    <button type="submit" class="btn btn-primary btn-lg btn-block py-5 mb-4">Сохранить изменения</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>



                <div class="col-md-12">
                    <div class="box">
                        <div class="box-header with-border">
                            <h4 class="box-title">Форма для редактирования или удаления товаров</h4>
                        </div>
                        <div class="mt-20 mr-20">
                            <form action="/admin/price">
                                <select class="nice-select form-control w-25 ml-auto" name="sort">
                                    <option value="all" @if($sort == 'all') selected @endif>Все категории товаров</option>
                                    @isset($podcategory)
                                        @foreach($category as $item)
                                            <option value="{!! $item->id !!}" @if($sort == $item->id) selected @endif>- {!! $item->name !!}</option>
                                            @if($podcategory[$item->id] != false)
                                                @foreach($podcategory[$item->id] as $item2)
                                                    <option value="{!! $item2->id !!}" @if($sort == $item2->id) selected @endif>&emsp;-- {!! $item2->name !!}</option>
                                                @endforeach
                                            @endif
                                        @endforeach
                                    @endisset
                                </select>
                            </form>
                        </div>
                        <div class="box-body">
                            <div class="table-responsive">
                                <form action="/admin/price" method="post">
                                    @csrf
                                    <table id="tickets" class="table mt-0 table-hover no-wrap table-striped table-bordered" data-page-size="10">
                                        <thead>
                                            <tr class="bg-dark">
                                                <th class="text-center">ID #</th>
                                                <th>Название товара</th>
                                                <th>Категория товара</th>
                                                <th class="text-center">Цена</th>
                                                <th class="text-center">Статус</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @isset($products)
                                                @foreach($products as $item)
                                                    <tr>
                                                        <td class="text-center">
                                                            {!! $item->id !!}
                                                            <input type="text" name="productID[]" value="{!! $item->id !!}" hidden>
                                                        </td>
                                                        <td>
                                                            <a href="/admin/products/{!! $item->id !!}" class="mx-5" data-toggle="tooltip" data-original-title="Редактировать">
                                                                {!! $item->title !!}
                                                            </a>
                                                        </td>
                                                        <td>
                                                            {!! $item->category->name !!}
                                                        </td>
                                                        <td class="text-center">
                                                            <input name="price[]" type="text" value="{!! $item->price !!}">
                                                        </td>
                                                        <td class="text-center">
                                                            <select name="statusID[]" class="form-control">
                                                                <option value="0" @if($item->status == 0) selected @endif>Обычнй товар</option>
                                                                <option value="1" @if($item->status == 1) selected @endif>Избранный товар №1</option>
                                                                <option value="2" @if($item->status == 2) selected @endif>Избранный товар №2</option>
                                                                <option value="3" @if($item->status == 3) selected @endif>Избранный товар №3</option>
                                                                <option value="4" @if($item->status == 4) selected @endif>Избранный товар №4</option>
                                                                <option value="5" @if($item->status == 5) selected @endif>Товара нет в наличии</option>
                                                            </select>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            @endisset
                                        </tbody>
                                    </table>
                                    <button type="submit" class="btn btn-primary btn-lg btn-block py-5 mb-4">Сохранить изменения</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    @isset($products)
                        @if($products->lastPage() > 1)
                            <nav class="mt-15 pb-10">
                                <ul class="pagination justify-content-center">
                                    @if($products->currentPage() == 1)
                                        <li class="page-item disabled"><a class="page-link" href="#"><span class="ion-ios-arrow-thin-left"></span></a></li>
                                    @else
                                        <li class="page-item"><a class="page-link" href="{!! $products->url(($products->currentPage() - 1)) !!}"><span class="ion-ios-arrow-thin-left"></span></a></li>
                                    @endif
                                    @if($products->currentPage() - 5 >= 1)
                                        <li class="page-item"><a class="page-link" href="{!! $products->url(1) !!}">...</a></li>
                                    @endif
                                    @for($i = 1; $i <= $products->lastPage(); $i++)
                                        @if($i >= ($products->currentPage() + 5) || $i <= ($products->currentPage() - 5))
                                        @elseif($products->currentPage() == $i)
                                            <li class="page-item active"><a href="javascript:void(0)" class="page-link">{!! $i !!}</a></li>
                                        @else
                                            <li  class="page-item"><a href="{!! $products->url($i) !!}" class="page-link">{!! $i !!}</a></li>
                                        @endif
                                    @endfor
                                    @if($products->currentPage() + 5 <= $products->lastPage())
                                        <li class="page-item"><a class="page-link" href="{!! $products->url(($products->lastPage())) !!}">...</a></li>
                                    @endif
                                    @if($products->currentPage() !== $products->lastPage())
                                        <li class="page-item "><a class="page-link" href="{!! $products->url(($products->currentPage() + 1)) !!}"><span class="ion-ios-arrow-thin-right"></span></a></li>
                                    @else
                                        <li class="page-item disabled"><a class="page-link" href="#"><span class="ion-ios-arrow-thin-right"></span></a></li>
                                    @endif
                                </ul>
                            </nav>
                        @endif
                    @endisset
                </div>
            </div>
        </section>
    </section>
