    <!-- Text Wrapper. Contains page content -->
    <section class="content-wrapper">
        <!-- Text Header (Page header) -->
        <section class="content-header">
            <h1>
                Список заказов
            </h1>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/admin"><i class="fa fa-dashboard"></i> Главная</a></li>
                <li class="breadcrumb-item active">Заказы</li>
                <li class="breadcrumb-item active">Список заказов</li>
            </ol>
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    @if(session()->has('flash_message'))
                        <div class="alert alert-success alert-dismissible alert-save">
                            {{ session()->get('flash_message') }}
                        </div>
                    @endif
                </div>
                <div class="col-md-12">
                    <div class="box">
                        <div class="box-header with-border">
                            <h4 class="box-title">Форма для обработки заказов</h4>
                        </div>
                        <div class="box-body">
                            <div class="table-responsive">
                                <table id="tickets" class="table mt-0 table-hover no-wrap table-striped table-bordered" data-page-size="10">
                                    <thead>
                                        <tr class="bg-dark">
                                            <th class="text-center">ID #</th>
                                            <th class="text-center">Статус</th>
                                            <th class="text-center">Заказчик</th>
                                            <th class="text-center">Телефон</th>
                                            <th class="text-center">Email</th>
                                            <th class="text-center">Оплата</th>
                                            <th class="text-center">Дата</th>
                                            <th class="text-center">Хостинг</th>
                                            <th class="text-center">Действия</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @isset($orders)
                                            @foreach($orders as $item)
                                                <tr>
                                                    <td class="text-center">
                                                        {!! $item->id !!}
                                                    </td>
                                                    <td class="text-center">
                                                        {!! $brief[$item->id]['status'] !!}
                                                    </td>
                                                    <td class="text-center">
                                                            {!! $brief[$item->id]['user'] !!}
                                                    </td>
                                                    <td class="text-center">
                                                        {!! $brief[$item->id]['phone'] !!}
                                                    </td>
                                                    <td class="text-center">
                                                        {!! $brief[$item->id]['email'] !!}
                                                    </td>
                                                    <td class="text-center">
                                                        <div class="label label-danger"><strong>{!! $item->status !!}</strong></div>
                                                    </td>
                                                    <td  class="text-center">
                                                        {!! $item->created_at !!}
                                                    </td>
                                                    <td  class="text-center">
                                                        {!! $item->date_host !!}
                                                    </td>
                                                    <td  class="text-center">
                                                        <a href="/admin/orders/{!! $item->id !!}" class="mx-5" data-toggle="tooltip" data-original-title="Редактировать">
                                                            <button type="button" class="btn btn-sm btn-danger-outline" data-toggle="tooltip" data-original-title="Delete"><i class="ti-pencil" aria-hidden="true"></i></button>
                                                        </a>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endisset
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    @isset($orders)
                        @if($orders->lastPage() > 1)
                            <nav class="mt-15 pb-10">
                                <ul class="pagination justify-content-center">
                                    @if($orders->currentPage() == 1)
                                        <li class="page-item disabled"><a class="page-link" href="#"><span class="ion-ios-arrow-thin-left"></span></a></li>
                                    @else
                                        <li class="page-item"><a class="page-link" href="{!! $orders->url(($orders->currentPage() - 1)) !!}"><span class="ion-ios-arrow-thin-left"></span></a></li>
                                    @endif
                                    @if($orders->currentPage() - 5 >= 1)
                                        <li class="page-item"><a class="page-link" href="{!! $orders->url(1) !!}">...</a></li>
                                    @endif
                                    @for($i = 1; $i <= $orders->lastPage(); $i++)
                                        @if($i >= ($orders->currentPage() + 5) || $i <= ($orders->currentPage() - 5))
                                        @elseif($orders->currentPage() == $i)
                                            <li class="page-item active"><a href="javascript:void(0)" class="page-link">{!! $i !!}</a></li>
                                        @else
                                            <li  class="page-item"><a href="{!! $orders->url($i) !!}" class="page-link">{!! $i !!}</a></li>
                                        @endif
                                    @endfor
                                    @if($orders->currentPage() + 5 <= $orders->lastPage())
                                        <li class="page-item"><a class="page-link" href="{!! $orders->url(($orders->lastPage())) !!}">...</a></li>
                                    @endif
                                    @if($orders->currentPage() !== $orders->lastPage())
                                        <li class="page-item "><a class="page-link" href="{!! $orders->url(($orders->currentPage() + 1)) !!}"><span class="ion-ios-arrow-thin-right"></span></a></li>
                                    @else
                                        <li class="page-item disabled"><a class="page-link" href="#"><span class="ion-ios-arrow-thin-right"></span></a></li>
                                    @endif
                                </ul>
                            </nav>
                        @endif
                    @endisset
                </div>
            </div>
        </section>
    </section>
