    <script src="{{ asset('/js/ckeditor/ckeditor.js') }}" type="text/javascript" charset="utf-8" ></script>
    <!-- Text Wrapper. Contains page content -->
    <section class="content-wrapper">
        <!-- Text Header (Page header) -->
        <section class="content-header">
            <h1>
                Заказ №{{ $orders->id }} - {!! $brief['user'] !!} - {!! $brief['phone'] !!}
            </h1>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/admin"><i class="fa fa-dashboard"></i> Главная</a></li>
                <li class="breadcrumb-item active"><a href="/admin/order">Заказы</a></li>
                <li class="breadcrumb-item active">Заказ №{{ $orders->id }}</li>
            </ol>
        </section>

        <!-- Main content -->

        <section class="content">
            <div class="posts">
                <div class="brief">
                    <div class="row fields">
                        <div class="col-sm-12 content">
                            <!-- step -->
                            <div class="step border border-danger p-50">
                                <div class="step-header">
                                    <h2>Контактные данные <small><i class="fa fa-address-card-o"></i></small></h2>
                                </div>
                                <div class="step-content">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group hidden">
                                                <label class="text-danger font-size-16" for="user">Имя <span class="red">*</span></label>
                                                @isset($brief['user'])
                                                <input type="text" class="form-control bg-white" name="user" placeholder="{!! $brief['user'] !!}" disabled>
                                                @endisset
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="email">E-mail <span class="red">*</span></label>
                                                @isset($brief['email'])
                                                <input type="email" class="form-control bg-white" name="email" placeholder="{!! $brief['email'] !!}" required="" disabled>
                                                @endisset
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="phone">Телефон <span class="red">*</span></label>
                                                @isset($brief['phone'])
                                                <input type="text" class="form-control phone bg-white" name="phone" placeholder="{!! $brief['phone'] !!}" required="" disabled>
                                                @endisset
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- / step -->
                            <!-- step -->
                            <div class="step border border-danger p-50 mt-50">
                                <div class="step-header">
                                    <h2>Общая информация <small><i class="fa fa-info"></i></small></h2>
                                </div>
                                <div class="step-content">
                                    <div class="row">
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="company">Компания</label>
                                                @isset($brief['company'])
                                                <input type="text" class="form-control bg-white" name="company" placeholder="{!! $brief['company'] !!}" disabled>
                                                @endisset
                                            </div>

                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="sphere">Сфера деятельности</label>
                                                @isset($brief['sphere'])
                                                <input type="text" class="form-control bg-white" name="sphere" placeholder="{!! $brief['sphere'] !!}" disabled>
                                                @endisset
                                            </div>
                                        </div>
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="morecompanyinfo">Дополнительная информация о компании</label>
                                                @isset($brief['morecompanyinfo'])
                                                <textarea name="morecompanyinfo" class="form-control bg-white" disabled>{!! $brief['morecompanyinfo'] !!}</textarea>
                                                @endisset
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="defsite">Существующий сайт</label>
                                                @isset($brief['defsite'])
                                                <input type="text" class="form-control bg-white" name="defsite" placeholder="{!! $brief['defsite'] !!}" disabled>
                                                @endisset
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="newsite">Планируемый адрес сайта</label>
                                                @isset($brief['newsite'])
                                                <input type="text" class="form-control bg-white" name="newsite" placeholder="{!! $brief['newsite'] !!}" disabled>
                                                @endisset
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- / step -->
                            <!-- step -->
                            <div class="step border border-danger p-50 mt-50">
                                <div class="step-header">
                                    <h2>Товары и услуги <small><i class="fa fa-shopping-cart"></i></small></h2>
                                </div>
                                <div class="step-content">
                                    <div class="row">
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="productsgroups">Основные группы продукции и/или услуг</label>
                                                @isset($brief['productsgroups'])
                                                <textarea name="productsgroups" class="form-control bg-white" disabled>{!! $brief['productsgroups'] !!}</textarea>
                                                @endisset
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="dopproductsgroups">Дополнительная информация о продукции/услугах</label>
                                                @isset($brief['dopproductsgroups'])
                                                <textarea name="dopproductsgroups" class="form-control bg-white" disabled>{!! $brief['dopproductsgroups'] !!}</textarea>
                                                @endisset
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- / step -->
                            <!-- step -->
                            <div class="step border border-danger p-50 mt-50">
                                <div class="step-header">
                                    <h2>Ввеб-сайт <small><i class="fa fa-sitemap"></i></small></h2>
                                </div>
                                <div class="step-content">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="sitename">Предполагаемое наименование сайта</label>
                                                @isset($brief['sitename'])
                                                <input type="text" class="form-control bg-white" name="sitename" placeholder="{!! $brief['sitename'] !!}" disabled>
                                                @endisset
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="menu">Основные разделы сайта</label>
                                                @isset($brief['menu'])
                                                @foreach($brief['menu'] as $item)
                                                    <div class="checkbox">
                                                        <label>
                                                            <input type="checkbox" name="menu[]" value="{!! $item !!}">
                                                            {!! $item !!}
                                                        </label>
                                                    </div>
                                                @endforeach
                                                @endisset
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="sitetasks">Основные элементы дизайна</label>
                                                @isset($brief['sitetasks'])
                                                @foreach($brief['sitetasks'] as $item)
                                                    <div class="checkbox">
                                                        <label>
                                                            <input type="checkbox" name="sitetasks[]" value="{!! $item !!}">
                                                            {!! $item !!}
                                                        </label>
                                                    </div>
                                                @endforeach
                                                @endisset
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="dopmenu">Дополнительные разделы сайта (за дополнительную оплату)</label>
                                                @isset($brief['dopmenu'])
                                                <textarea name="dopmenu" class="form-control bg-white" disabled>{!! $brief['dopmenu'] !!}</textarea>
                                                @endisset
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="dopsitetasks">Дополнительные элементы сайта (за дополнительную оплату)</label>
                                                @isset($brief['dopsitetasks'])
                                                <textarea name="dopsitetasks" class="form-control bg-white" disabled>{!! $brief['dopsitetasks'] !!}</textarea>
                                                @endisset
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- / step -->
                            <!-- step -->
                            <div class="step border border-danger p-50 mt-50">
                                <div class="step-header">
                                    <h2>Материалы <small><i class="fa fa-cubes"></i></small></h2>
                                </div>
                                <div class="step-content">
                                    <div class="row">
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="firmstyle">Фирменный стиль</label>
                                                <div class="radio">
                                                    @isset($brief['firmstyle'])
                                                    <label>
                                                        <input type="radio" name="firmstyle" value="{!! $brief['firmstyle'] !!}" disabled>
                                                        {!! $brief['firmstyle'] !!}
                                                    </label>
                                                    @endisset
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="graphics">Ручная графика</label>
                                                <div class="radio">
                                                    @isset($brief['graphics'])
                                                    <label>
                                                        <input type="radio" name="graphics" value="{!! $brief['graphics'] !!}" disabled>
                                                        {!! $brief['graphics'] !!}
                                                    </label>
                                                    @endisset
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="photos">Фотографии</label>
                                                <div class="radio">
                                                    @isset($brief['photos'])
                                                    <label>
                                                        <input type="radio" name="photos" value="{!! $brief['photos'] !!}" disabled>
                                                        {!! $brief['photos'] !!}
                                                    </label>
                                                    @endisset
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="graphicsp">Использование какой графики предпочтительнее</label>
                                                <div class="radio">
                                                    @isset($brief['graphicsp'])
                                                    <label>
                                                        <input type="radio" name="graphicsp" value="{!! $brief['graphicsp'] !!}" disabled>
                                                        {!! $brief['graphicsp'] !!}
                                                    </label>
                                                    @endisset
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- / step -->
                            <!-- step -->
                            <div class="step border border-danger p-50 mt-50">
                                <div class="step-header">
                                    <h2>Дизайн <small><i class="fa fa-paint-brush"></i></small></h2>
                                </div>
                                <div class="step-content">
                                    <div class="row">
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="style">Настроение и ассоциации, которые должен вызывать дизайн</label>
                                                <div class="radio">
                                                    @isset($brief['style'])
                                                    <label>
                                                        <input type="radio" name="style" value="{!! $brief['style'] !!}" disabled>
                                                        {!! $brief['style'] !!}
                                                    </label>
                                                    @endisset
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="frontend">Требования к внешнему виду (дизайну) сайта</label>
                                                <div class="radio">
                                                    @isset($brief['frontend'])
                                                    <label>
                                                        <input type="radio" name="frontend" value="{!! $brief['frontend'] !!}" disabled>
                                                        {!! $brief['frontend'] !!}
                                                    </label>
                                                    @endisset
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="mainpage">Наличие / расположение блоков на главной странице (какие блоки должны быть виднее всего)</label>
                                                @isset($brief['mainpage'])
                                                <textarea name="mainpage" class="form-control bg-white" disabled>{!! $brief['mainpage'] !!}</textarea>
                                                @endisset
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- / step -->
                            <!-- step -->
                            <div class="step border border-danger p-50 mt-50 mb-50">
                                <div class="step-header">
                                    <h2>Примеры <small><i class="fa fa-archive"></i></small></h2>
                                </div>
                                <div class="step-content">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="examples">Примеры удачный сайтов, цветов, расположения элементов (не менее 3-х)</label>
                                                @isset($brief['examples'])
                                                <textarea name="examples" class="form-control bg-white" disabled>{!! $brief['examples'] !!}</textarea>
                                                @endisset
                                            </div>
                                        </div>
                                        <div class="col-sm-12">
                                            <div class="form-group">
                                                <label class="text-danger font-size-16" for="wishes">Ваши пожелания</label>
                                                @isset($brief['wishes'])
                                                <textarea name="wishes" class="form-control bg-white" disabled>{!! $brief['wishes'] !!}</textarea>
                                                @endisset
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- / step -->
                            <form action="/admin/orders" method="post">
                                @csrf
                                <input type="text" name="status" value="comments" hidden>
                                <input type="text" name="orderID" value="{!! $orders->id !!}" hidden>
                                <div class="step border border-danger p-50 mt-50 mb-50">
                                    <div class="step-header">
                                        <h2>Комментарии <small><i class="fa fa-archive"></i></small></h2>
                                    </div>
                                    <div class="step-content">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <textarea name="comments" class="form-control">{!! $orders->comments !!}</textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="submit" class="btn btn-primary">Отправить</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </section>
    <script>let editor1 = CKEDITOR.replace( 'editor1' );</script>
    <script>let editor2 = CKEDITOR.replace( 'editor2' );</script>
    <script>let editor3 = CKEDITOR.replace( 'editor3' );</script>
    <script>let editor4 = CKEDITOR.replace( 'editor4', {toolbar: [{ name: 'insert', items: [ 'Image'] },]});</script>
