    <!-- Text Wrapper. Contains page content -->
    <section class="content-wrapper">
        <!-- Text Header (Page header) -->
        <section class="content-header">
            <h1>
                Сообщения
            </h1>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/admin"><i class="fa fa-dashboard"></i> Главная</a></li>
                <li class="breadcrumb-item active">Сообщения</li>
            </ol>
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    @if(session()->has('flash_message'))
                        <div class="alert alert-success alert-dismissible alert-save">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            <h4><i class="icon fa fa-check"></i> Сообщение!</h4>
                            {{ session()->get('flash_message') }}
                        </div>
                    @endif
                    @if(session()->has('flash_message_error'))
                        <div class="alert alert-danger alert-err alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            <h4><i class="icon fa fa-ban"></i> Сообщение!</h4>
                            {{ session()->get('flash_message_error') }}
                        </div>
                    @endif
                    <div class="box">
                        <div class="box-body">
                            <div class="row">
                                <div class="col-lg-3 col-12">
                                    <div class="h-p100 p-15 bg-light">
                                        <div class="box bg-transparent no-border no-shadow">
                                            <div class="box-header with-border">
                                                <h3 class="box-title">Папки</h3>
                                            </div>
                                            <div class="box-body no-padding mailbox-nav">
                                                <ul class="nav nav-pills flex-column">
                                                    <li class="nav-item">
                                                        <a class="nav-link @if(empty($_GET['status'])) active @endif" href="/admin/messages">
                                                            <i class="ion ion-ios-email-outline"></i> Входящие<span class="label label-success float-right">@isset($messageCount){!! $messageCount['1'] !!}@else 0 @endisset</span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link @if(isset($_GET['status']) and $_GET['status'] == 2) active @endif" href="/admin/messages?status=2">
                                                            <i class="ion ion-star"></i>  Избранные <span class="label label-warning float-right">@isset($messageCount){!! $messageCount['2'] !!}@else 0 @endisset</span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link @if(isset($_GET['status']) and $_GET['status'] == 3) active @endif" href="/admin/messages?status=3">
                                                            <i class="ion ion-trash-a"></i> Удаленные <span class="label label-danger float-right">@isset($messageCount){!! $messageCount['3'] !!}@else 0 @endisset</span>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                            <!-- /.box-body -->
                                        </div>
                                    </div>
                                </div>
                                <!-- /.col -->
                                <div class="col-lg-9 col-12">
                                    <div class="box bg-transparent no-shadow">
                                        <div class="box-header with-border">
                                            <h3 class="box-title">Сообщения</h3>
                                        </div>
                                        <!-- /.box-header -->
                                        <div class="box-body">
                                            <div class="mailbox-controls">
                                                <a href="/admin/messages" class="btn btn-outline btn-sm float-left mr-10"><i class="fas fa-sync"></i></a>
                                                <form id="form-de-1-all" action="/admin/messages" method="post">
                                                    @csrf
                                                    <input type="text" name="status" value="delAll" hidden>
                                                    <button type="submit" class="btn btn-outline">Удалить все сообщения <i class="fas fa-trash"></i></button>
                                                </form>
                                                <div class="float-right">
                                                    @isset($messagesP)
                                                        {!! $messagesP->firstItem() !!}-{!! $messagesP->lastItem() !!}/{!! $messagesP->total() !!}
                                                        @if($messagesP->lastPage() > 1)
                                                            <div class="btn-group">
                                                                @if($messagesP->currentPage() == 1)
                                                                <button type="button" class="btn btn-outline btn-sm"><i class="fa fa-chevron-left"></i></button>
                                                                @else
                                                                    <a href="{!! $messagesP->url(($messagesP->currentPage() - 1)) !!}">
                                                                        <button type="button" class="btn btn-outline btn-sm"><i class="fa fa-chevron-left"></i></button>
                                                                    </a>
                                                                @endif
                                                                @if($messagesP->currentPage() !== $messagesP->lastPage())
                                                                    <a href="{!! $messagesP->url(($messagesP->currentPage() + 1)) !!}">
                                                                        <button type="button" class="btn btn-outline btn-sm"><i class="fa fa-chevron-right"></i></button>
                                                                    </a>
                                                                @else
                                                                    <button type="button" class="btn btn-outline btn-sm"><i class="fa fa-chevron-right"></i></button>
                                                                @endif
                                                            </div>
                                                        @endif
                                                    @endisset
                                                    <!-- /.btn-group -->
                                                </div>
                                                <!-- /.pull-right -->
                                            </div>
                                            <div class="mailbox-messages">
                                                <div class="table-responsive">
                                                    <table class="table table-hover table-striped">
                                                        <tbody>
                                                            @isset($messagesP)
                                                                @foreach($messagesP as $item)
                                                                    <tr>
                                                                        <td><input type="checkbox"></td>
                                                                        <td class="mailbox-star">
                                                                            @if(isset($_GET['status']) and $_GET['status'] == 3)
                                                                                <form id="form-de-1-{!! $item->id !!}" action="/admin/messages" method="post">
                                                                                    @csrf
                                                                                    <input type="text" name="status" value="trash" hidden>
                                                                                    <input type="text" name="messageID" value="{!! $item->id !!}" hidden>
                                                                                    <button type="submit" class="btn btn-outline">
                                                                                        <i class="fa fa-trash text-danger"></i>
                                                                                    </button>
                                                                                </form>
                                                                            @else
                                                                                <form id="form-del-2-{!! $item->id !!}" action="/admin/messages" method="post">
                                                                                    @csrf
                                                                                    <input type="text" name="status" value="del" hidden>
                                                                                    <input type="text" name="messageID" value="{!! $item->id !!}" hidden>
                                                                                    <button type="submit" class="btn btn-outline">
                                                                                        <i class="fa fa-trash text-danger"></i>
                                                                                    </button>
                                                                                </form>
                                                                            @endif
                                                                        </td>
                                                                        <td class="mailbox-star">
                                                                            @if(isset($_GET['status']) and $_GET['status'] == 2)
                                                                                <form id="form-star-1-{!! $item->id !!}" action="/admin/messages" method="post">
                                                                                    @csrf
                                                                                    <input type="text" name="status" value="star0" hidden>
                                                                                    <input type="text" name="messageID" value="{!! $item->id !!}" hidden>
                                                                                    <button type="submit" class="btn btn-outline">
                                                                                        <i class="fas fa-star text-yellow"></i>
                                                                                    </button>
                                                                                </form>
                                                                            @else
                                                                                <form id="form-star-2-{!! $item->id !!}" action="/admin/messages" method="post">
                                                                                    @csrf
                                                                                    <input type="text" name="status" value="star" hidden>
                                                                                    <input type="text" name="messageID" value="{!! $item->id !!}" hidden>
                                                                                    <button type="submit" class="btn btn-outline">
                                                                                        <i class="far fa-star text-yellow"></i>
                                                                                    </button>
                                                                                </form>
                                                                            @endif
                                                                        </td>
                                                                        <td class="w-80"><img class="avatar" src="/images/user-mail.png" alt="..."></td>
                                                                        <td class="mailbox-name">
                                                                            @if($item->status === 1)
                                                                                <strong>{!! $item->name !!}</strong>
                                                                            @else
                                                                                {!! $item->name !!}
                                                                            @endif
                                                                        </td>
                                                                        <td class="mailbox-subject">
                                                                            @if($item->status === 1)
                                                                                <a href="/admin/messages/{!! $item->id !!}" class="text-primary">
                                                                                    <strong>{!! str_limit($item->title, 25) !!} - {!! str_limit($item->message, 50) !!}</strong>
                                                                                </a>
                                                                            @else
                                                                                <a href="/admin/messages/{!! $item->id !!}">
                                                                                    {!! str_limit($item->title, 25) !!} - {!! str_limit($item->message, 50) !!}
                                                                                </a>
                                                                            @endif
                                                                        </td>
                                                                        <td class="mailbox-attachment"></td>
                                                                        <td class="mailbox-date">{!! $item->created_at->format('d.m.Y') !!}</td>
                                                                    </tr>
                                                                @endforeach
                                                            @endisset
                                                        </tbody>
                                                    </table>
                                                </div>
                                                <!-- /.table --count($messages) -->
                                            </div>
                                            <!-- /.mail-box-messages -->
                                        </div>
                                        <!-- /.box-body -->
                                    </div>
                                    <!-- /. box -->
                                </div>
                                <!-- /.col -->
                            </div>
                            <!-- /.row -->
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- /.content -->
    </section>

    {{--@if($messages->lastPage() > 1)
            <div class="pagination__wrapper">
                <ul class="pagination">
                    @if($messages->currentPage() == 1)
                        <li><button class="prev" title="previous page">&#10094;</button></li>
                    @else
                        <li><a href="{!! $messages->url(($messages->currentPage() - 1)) !!}"><button class="prev" title="previous page">&#10094;</button></a></li>
                    @endif
                    @if($messages->currentPage() - 5 >= 1)
                        <li><a href="{!! $messages->url(1) !!}"><button class="" title="page - 1">...</button></a></li>
                    @endif
                    @for($i = 1; $i <= $messages->lastPage(); $i++)
                        @if($i >= ($messages->currentPage() + 5) || $i <= ($messages->currentPage() - 5))
                        @elseif($messages->currentPage() == $i)
                            <li><button class="active" title="current page - page {!! $i !!}">{!! $i !!}</button></li>
                        @else
                            <li><a href="{!! $messages->url($i) !!}"><button class="" title="page {!! $i !!}">{!! $i !!}</button></a></li>
                        @endif
                    @endfor
                    @if($messages->currentPage() + 5 <= $messages->lastPage())
                        <li><a href="{!! $messages->url(($messages->lastPage())) !!}"><button class="" title="page - {!! $messages->lastPage() !!}">...</button></a></li>
                    @endif
                    @if($messages->currentPage() !== $messages->lastPage())
                        <li><a href="{!! $messages->url(($messages->currentPage() + 1)) !!}"><button class="next" title="next page">&#10095;</button></a></li>
                    @else
                        <li><button class="next" title="next page">&#10095;</button></li>
                    @endif
                </ul>
            </div>
        @endif--}}