    <!-- Text Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xl-3 col-md-6 col-12 text-center">
                    <div class="box box-body">
                        <h6 class="text-uppercase">Средняя длительность <br>сеансов за сегодня</h6>
                        <div class="flexbox mt-2">
                            <span class="fa fa-tachometer-alt text-danger font-size-30"></span>
                            <span class=" font-size-30">{!! $stat['duration'] !!} мин.</span>
                        </div>
                    </div>
                </div>
                <!-- /.col -->
                <div class="col-xl-3 col-md-6 col-12 text-center">
                    <div class="box box-body">
                        <h6 class="text-uppercase">Количество просмотров <br> страниц на посетителя</h6>
                        <div class="flexbox mt-2">
                            <span class="fas fa-eye text-info font-size-30"></span>
                            <span class=" font-size-30">{!! $stat['pages'] !!} стр.</span>
                        </div>
                    </div>
                </div>
                <!-- /.col -->

                <!-- fix for small devices only -->
                <div class="clearfix visible-sm-block"></div>

                <div class="col-xl-3 col-md-6 col-12 text-center">
                    <div class="box box-body">
                        <h6 class="text-uppercase">Общее количество <br> пользователей</h6>
                        <div class="flexbox mt-2">
                            <span class="fa fa-user-plus font-size-30 text-primary"></span>
                            <span class=" font-size-30">{!! $users->count() !!}</span>
                        </div>
                    </div>
                </div>
                <!-- /.col -->
                <div class="col-xl-3 col-md-6 col-12 text-center">
                    <div class="box box-body">
                        <h6 class="text-uppercase">Количество входящих <br> сообщений</h6>
                        <div class="flexbox mt-2">
                            <span class="fas fa-envelope font-size-30 text-success"></span>
                            @if (isset($messages))
                                <span class=" font-size-30">{!! $messages->count() !!}</span>
                            @else
                                <span class=" font-size-30">0</span>
                            @endif
                        </div>
                    </div>
                </div>
                <!-- /.col -->
            </div>

            <div class="row">

                <div class="col-12 col-lg-6">
                    <!-- AREA CHART -->
                    <div class="box">
                        <div class="box-header with-border">
                            <h4 class="box-title">Статистика посещаемости за сегодня</h4>
                            <ul class="box-controls pull-right">
                                <li><a class="box-btn-close" href="#"></a></li>
                                <li><a class="box-btn-slide" href="#"></a></li>
                                <li><a class="box-btn-fullscreen" href="#"></a></li>
                            </ul>
                        </div>
                        <div class="box-body">
                            <div class="chart">
                                <canvas id="stat_1" height="120"></canvas>
                            </div>
                        </div>
                        <!-- /.box-body -->
                    </div>
                    <!-- /.box -->
                </div>

                <div class="col-12 col-lg-6">
                    <!-- AREA CHART -->
                    <div class="box">
                        <div class="box-header with-border">
                            <h4 class="box-title">Пол и возраст посетителей, в процентах (%)</h4>
                            <ul class="box-controls pull-right">
                                <li><a class="box-btn-close" href="#"></a></li>
                                <li><a class="box-btn-slide" href="#"></a></li>
                                <li><a class="box-btn-fullscreen" href="#"></a></li>
                            </ul>
                        </div>
                        <div class="box-body">
                            <div class="chart">
                                <canvas id="stat_2" height="120"></canvas>
                            </div>
                        </div>
                        <!-- /.box-body -->
                    </div>
                    <!-- /.box -->
                </div>

                <div class="col-12 col-lg-6 col-xl-6">
                    <div class="box">
                        <div class="box-header with-border">
                            <h4 class="box-title">Количество посетителей с разными браузерами</h4>
                            <ul class="box-controls pull-right">
                                <li><a class="box-btn-close" href="#"></a></li>
                                <li><a class="box-btn-slide" href="#"></a></li>
                                <li><a class="box-btn-fullscreen" href="#"></a></li>
                            </ul>
                        </div>

                        <div class="box-body">
                            <div class="text-center py-20">
                                <div class="donut" data-peity='{ "fill": ["#7460ee", "#26c6da", "#fc4b6c"], "radius": 108, "innerRadius": 50  }' >{!! $stat['browsers13'] !!}, {!! $stat['browsers23'] !!}, {!! $stat['browsers33'] !!}</div>
                            </div>

                            <ul class="flexbox flex-justified text-center mt-70">
                                <li class="br-1">
                                    <div class="font-size-20 text-primary">{!! $stat['browsers12'] !!}</div>
                                    <small class="font-size-12 text-fade">{!! $stat['browsers11'] !!}</small>
                                </li>

                                <li class="br-1">
                                    <div class="font-size-20 text-success">{!! $stat['browsers22'] !!}</div>
                                    <small class="font-size-12 text-fade">{!! $stat['browsers21'] !!}</small>
                                </li>

                                <li>
                                    <div class="font-size-20 text-danger">{!! $stat['browsers32'] !!}</div>
                                    <small class="font-size-12 text-fade">{!! $stat['browsers31'] !!}</small>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-lg-6 col-xl-6">
                    <div class="box">
                        <div class="box-header with-border">
                            <h4 class="box-title">Количество посетителей из разных стран</h4>
                            <ul class="box-controls pull-right">
                                <li><a class="box-btn-close" href="#"></a></li>
                                <li><a class="box-btn-slide" href="#"></a></li>
                                <li><a class="box-btn-fullscreen" href="#"></a></li>
                            </ul>
                        </div>
                        <div class="box-body px-0 pt-0 pb-30 text-center m-auto">
                            @foreach($stat['countries'] as $item)
                                <div id="browsers33" class="mt-4">{!! $item !!}</div>
                            @endforeach
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <a href="https://analytics.google.com/analytics/" class="btn btn-block btn-primary py-4 mb-4 mt-0">Просмотреть полную статистику</a>
                </div>

            </div>
            <!-- /.row -->
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

    <div hidden>
        <div id="statViews">{!! $stat['views'] !!}</div>
        <div id="statVisitors">{!! $stat['visitors'] !!}</div>
        <div id="statDuration">{!! $stat['duration'] !!}</div>
        <div id="statPages">{!! $stat['pages'] !!}</div>

        <div id="demo1-1">{!! $stat['demo1-1'] !!}</div>
        <div id="demo1-2">{!! $stat['demo1-2'] !!}</div>
        <div id="demo2-1">{!! $stat['demo2-1'] !!}</div>
        <div id="demo2-2">{!! $stat['demo2-2'] !!}</div>
        <div id="demo3-1">{!! $stat['demo3-1'] !!}</div>
        <div id="demo3-2">{!! $stat['demo3-2'] !!}</div>
        <div id="demo4-1">{!! $stat['demo4-1'] !!}</div>
        <div id="demo4-2">{!! $stat['demo4-2'] !!}</div>
    </div>

