    <!-- Text Wrapper. Contains page content -->
    <section class="content-wrapper">
        <!-- Text Header (Page header) -->
        <section class="content-header">
            <h1>
                Комментарии
            </h1>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/admin"><i class="fa fa-dashboard"></i> Главная</a></li>
                <li class="breadcrumb-item active">Статьи</li>
                <li class="breadcrumb-item active">Список статей</li>
            </ol>
        </section>

        <!-- Main content -->
        <section class="content pb-15">
            <div class="row">
                <div class="col-md-12">
                    @if(session()->has('flash_message'))
                        <div class="alert alert-success alert-dismissible alert-save">
                            {{ session()->get('flash_message') }}
                        </div>
                    @endif
                </div>
                <div class="col-md-12">
                    <div class="box">
                        <div class="box-header with-border">
                            <h4 class="box-title">Форма для редактирования или удаления комментариев</h4>
                        </div>
                        <div class="box-body">
                            <div class="table-responsive">
                                <table id="tickets" class="table mt-0 table-hover no-wrap table-striped table-bordered" data-page-size="10">
                                    <thead>
                                        <tr class="bg-dark">
                                            <th class="text-center">ID #</th>
                                            <th>Комментарий</th>
                                            <th>Автор</th>
                                            <th>Email</th>
                                            <th class="text-center">Действия</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @isset($comments)
                                            @foreach($comments as $item)
                                                <tr>
                                                    <td class="text-center">
                                                        {!! $item->id !!}
                                                    </td>
                                                    <td>
                                                        <a href="@if($item->category == 1){!! $aliasArticle[$item->id_post] !!}@elseif($item->category == 2){!! $aliasProduct[$item->id_post] !!}@endif" class="mx-5" data-toggle="tooltip" data-original-title="Редактировать">
                                                            {!! $item->comment !!}
                                                        </a>
                                                    </td>
                                                    <td>
                                                        {!! $item->name !!}
                                                    </td>
                                                    <td>
                                                        {!! $item->email !!}
                                                    </td>
                                                    <td class="text-center">
                                                        <form id="form-del-{!! $item->id !!}" class="settings inline" method="post" action="/admin/comments">
                                                            @csrf
                                                            <input type="text" name="status" value="del" hidden>
                                                            <input type="text" name="commentID" value="{!! $item->id !!}" hidden>
                                                            <button type="submit" class="btn btn-sm btn-danger-outline mx-5" data-toggle="tooltip" data-original-title="Удалить">
                                                                <i class="ti-trash" aria-hidden="true"></i>
                                                            </button>
                                                        </form>
                                                        @if($item->status == 0)
                                                            <div class="inline">
                                                                <form id="form-up-{!! $item->id !!}" class="settings inline" method="post" action="/admin/comments">
                                                                    @csrf
                                                                    <input type="text" name="status" value="edit" hidden>
                                                                    <input type="text" name="commentID" value="{!! $item->id !!}" hidden>
                                                                    <button type="submit" class="btn btn-sm btn-success-outline mx-5" data-toggle="tooltip" data-original-title="Публиковать">
                                                                        <i class="ti-star" aria-hidden="true"></i>
                                                                    </button>
                                                                </form>
                                                            </div>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endisset
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    @isset($comments)
                        @if($comments->lastPage() > 1)
                            <nav class="mt-15 pb-10">
                                <ul class="pagination justify-content-center">
                                    @if($comments->currentPage() == 1)
                                        <li class="page-item disabled"><a class="page-link" href="#"><span class="ion-ios-arrow-thin-left"></span></a></li>
                                    @else
                                        <li class="page-item"><a class="page-link" href="{!! $comments->url(($comments->currentPage() - 1)) !!}"><span class="ion-ios-arrow-thin-left"></span></a></li>
                                    @endif
                                    @if($comments->currentPage() - 5 >= 1)
                                        <li class="page-item"><a class="page-link" href="{!! $comments->url(1) !!}">...</a></li>
                                    @endif
                                    @for($i = 1; $i <= $comments->lastPage(); $i++)
                                        @if($i >= ($comments->currentPage() + 5) || $i <= ($comments->currentPage() - 5))
                                        @elseif($comments->currentPage() == $i)
                                            <li class="page-item active"><a href="javascript:void(0)" class="page-link">{!! $i !!}</a></li>
                                        @else
                                            <li  class="page-item"><a href="{!! $comments->url($i) !!}" class="page-link">{!! $i !!}</a></li>
                                        @endif
                                    @endfor
                                    @if($comments->currentPage() + 5 <= $comments->lastPage())
                                        <li class="page-item"><a class="page-link" href="{!! $comments->url(($comments->lastPage())) !!}">...</a></li>
                                    @endif
                                    @if($comments->currentPage() !== $comments->lastPage())
                                        <li class="page-item "><a class="page-link" href="{!! $comments->url(($comments->currentPage() + 1)) !!}"><span class="ion-ios-arrow-thin-right"></span></a></li>
                                    @else
                                        <li class="page-item disabled"><a class="page-link" href="#"><span class="ion-ios-arrow-thin-right"></span></a></li>
                                    @endif
                                </ul>
                            </nav>
                        @endif
                    @endisset
                </div>
            </div>
        </section>
    </section>
