    <!-- Text Wrapper. Contains page content -->
    <section class="content-wrapper">
        <!-- Text Header (Page header) -->
        <section class="content-header">
            <h1>
                Список товаров
            </h1>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/admin"><i class="fa fa-dashboard"></i> Главная</a></li>
                <li class="breadcrumb-item active">Товары</li>
                <li class="breadcrumb-item active">Список товаров</li>
            </ol>
        </section>

        <!-- Main content -->
        <section class="content pb-15">
            <div class="row">
                <div class="col-md-12">
                    @if(session()->has('flash_message'))
                        @if( session()->get('flash_message') == 'Вы успешно сохранили изменения!')
                            <div class="alert alert-success alert-dismissible alert-save">
                                {{ session()->get('flash_message') }}
                            </div>
                        @else
                            <div class="alert alert-danger alert-dismissible alert-save">
                                {{ session()->get('flash_message') }}
                            </div>
                        @endif
                    @endif
                </div>
                <div class="col-md-12">
                    <div class="box">
                        <div class="box-header with-border">
                            <h4 class="box-title">Форма для редактирования категорий товаров</h4>
                        </div>
                        <div class="box-body">
                            <div class="table-responsive">
                                <table id="tickets" class="table mt-0 table-hover no-wrap table-striped table-bordered" data-page-size="10">
                                    <thead>
                                        <tr class="bg-dark">
                                            <th class="text-center">ID #</th>
                                            {{--<th class="text-center">Родительская категория</th>--}}
                                            <th class="text-center">Название категории</th>
                                            <th class="text-center">Действия</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @isset($podcategory)
                                            @foreach($category as $item)
                                                <tr>
                                                    <td class="text-center bg-success">
                                                        {!!  $item->id !!}
                                                    </td>
                                                    {{--<td class="text-center bg-success">
                                                        Без категория
                                                    </td>--}}
                                                    <td class="text-left pl-50 bg-success">
                                                        <a href="/admin/category/{!! $item->id !!}" class="text-white text-decoration-none"><strong>{!! $item->name !!}</strong></a>
                                                    </td>
                                                    <td class="text-center bg-success">
                                                        <form id="form-del-{!! $item->id !!}" class="settings inline" method="post" action="/admin/category">
                                                            @csrf
                                                            <input type="text" name="status" value="del" hidden>
                                                            <input type="text" name="categoryID" value="{!! $item->id !!}" hidden>
                                                            <button type="submit" class="btn btn-sm btn-secondary-outline text-dark mx-5" data-toggle="tooltip" data-original-title="Удалить">
                                                                <i class="ti-trash" aria-hidden="true"></i>
                                                            </button>
                                                        </form>
                                                        <a href="/admin/category/{!! $item->id !!}" class="btn btn-sm btn-secondary-outline text-dark mx-5" data-toggle="tooltip" data-original-title="Редактировать">
                                                            <i class="ti-pencil" aria-hidden="true"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                                @if($podcategory[$item->id] != false)
                                                    @foreach($podcategory[$item->id] as $item2)
                                                        <tr>
                                                            <td class="text-center">
                                                                {!! $item2->id !!}
                                                            </td>
                                                           {{-- <td class="text-center">
                                                                {!! $item->name !!}
                                                            </td>--}}
                                                            <td class="text-center">
                                                                {!! $item2->name !!}
                                                            </td>
                                                            <td class="text-center">
                                                                <form id="form-del-{!! $item2->id !!}" class="settings inline" method="post" action="/admin/category">
                                                                    @csrf
                                                                    <input type="text" name="status" value="del" hidden>
                                                                    <input type="text" name="categoryID" value="{!! $item2->id !!}" hidden>
                                                                    <button type="submit" class="btn btn-sm btn-danger-outline mx-5" data-toggle="tooltip" data-original-title="Удалить">
                                                                        <i class="ti-trash" aria-hidden="true"></i>
                                                                    </button>
                                                                </form>
                                                                <a href="/admin/category/{!! $item2->id !!}" class="btn btn-sm btn-success-outline mx-5" data-toggle="tooltip" data-original-title="Редактировать">
                                                                    <i class="ti-pencil" aria-hidden="true"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                @endif
                                            @endforeach
                                        @endisset
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <a href="/admin/category/create" class="btn btn-primary btn-lg btn-block py-5 mb-4">Добавить новую категорию</a>
        </section>
    </section>
