    <!-- Text Wrapper. Contains page content -->
    <section class="content-wrapper">
        <!-- Text Header (Page header) -->
        <section class="content-header">
            <h1>
                Список товаров
            </h1>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="/admin"><i class="fa fa-dashboard"></i> Главная</a></li>
                <li class="breadcrumb-item active">Статьи</li>
                <li class="breadcrumb-item active">Список статей</li>
            </ol>
        </section>

        <!-- Main content -->
        <section class="content pb-15">
            <div class="row">
                <div class="col-md-12">
                    @if(session()->has('flash_message'))
                        <div class="alert alert-success alert-dismissible alert-save">
                            {{ session()->get('flash_message') }}
                        </div>
                    @endif
                </div>
                <div class="col-md-12">
                    <div class="box">
                        <div class="box-header with-border">
                            <h4 class="box-title">Форма для редактирования или удаления статей</h4>
                        </div>
                        <div class="box-body">
                            <div class="table-responsive">
                                <table id="tickets" class="table mt-0 table-hover no-wrap table-striped table-bordered" data-page-size="10">
                                    <thead>
                                        <tr class="bg-dark">
                                            <th class="text-center">ID #</th>
                                            <th>Название товара</th>
                                            <th class="text-center">Действия</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @isset($articles)
                                            @foreach($articles as $item)
                                                <tr>
                                                    <td class="text-center">
                                                        {!! $item->id !!}
                                                    </td>
                                                    <td>
                                                        <a href="/admin/articles/{!! $item->id !!}" class="mx-5" data-toggle="tooltip" data-original-title="Редактировать">
                                                            {!! $item->title !!}
                                                        </a>
                                                    </td>
                                                    <td class="text-center">
                                                        <form id="form-del-{!! $item->id !!}" class="settings inline" method="post" action="/admin/articles">
                                                            @csrf
                                                            <input type="text" name="status" value="del" hidden>
                                                            <input type="text" name="articleID" value="{!! $item->id !!}" hidden>
                                                            <button type="submit" class="btn btn-sm btn-danger-outline mx-5" data-toggle="tooltip" data-original-title="Удалить">
                                                                <i class="ti-trash" aria-hidden="true"></i>
                                                            </button>
                                                        </form>
                                                        <div class="inline">
                                                            <a href="/admin/articles/{!! $item->id !!}" class="btn btn-sm btn-success-outline mx-5" data-toggle="tooltip" data-original-title="Редактировать">
                                                                <i class="ti-pencil" aria-hidden="true"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endisset
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    @isset($articles)
                        @if($articles->lastPage() > 1)
                            <nav class="mt-15 pb-10">
                                <ul class="pagination justify-content-center">
                                    @if($articles->currentPage() == 1)
                                        <li class="page-item disabled"><a class="page-link" href="#"><span class="ion-ios-arrow-thin-left"></span></a></li>
                                    @else
                                        <li class="page-item"><a class="page-link" href="{!! $articles->url(($articles->currentPage() - 1)) !!}"><span class="ion-ios-arrow-thin-left"></span></a></li>
                                    @endif
                                    @if($articles->currentPage() - 5 >= 1)
                                        <li class="page-item"><a class="page-link" href="{!! $articles->url(1) !!}">...</a></li>
                                    @endif
                                    @for($i = 1; $i <= $articles->lastPage(); $i++)
                                        @if($i >= ($articles->currentPage() + 5) || $i <= ($articles->currentPage() - 5))
                                        @elseif($articles->currentPage() == $i)
                                            <li class="page-item active"><a href="javascript:void(0)" class="page-link">{!! $i !!}</a></li>
                                        @else
                                            <li  class="page-item"><a href="{!! $articles->url($i) !!}" class="page-link">{!! $i !!}</a></li>
                                        @endif
                                    @endfor
                                    @if($articles->currentPage() + 5 <= $articles->lastPage())
                                        <li class="page-item"><a class="page-link" href="{!! $articles->url(($articles->lastPage())) !!}">...</a></li>
                                    @endif
                                    @if($articles->currentPage() !== $articles->lastPage())
                                        <li class="page-item "><a class="page-link" href="{!! $articles->url(($articles->currentPage() + 1)) !!}"><span class="ion-ios-arrow-thin-right"></span></a></li>
                                    @else
                                        <li class="page-item disabled"><a class="page-link" href="#"><span class="ion-ios-arrow-thin-right"></span></a></li>
                                    @endif
                                </ul>
                            </nav>
                        @endif
                    @endisset
                </div>
            </div>
            <a href="/admin/articles/create" class="btn btn-primary btn-lg btn-block py-5 mb-4">Добавить новую статью</a>
        </section>
    </section>
