    <header class="main-header">
        <div class="inside-header">
            <!-- Logo -->
            <a href="/admin" class="logo">
                <!-- mini logo for sidebar mini 50x50 pixels -->
                <b class="logo-mini">
                    <span class="light-logo"><img src="/images/logo-light.png" alt="logo"></span>
                    <span class="dark-logo"><img src="/images/logo-dark.png" alt="logo"></span>
                </b>
                <!-- logo for regular state and mobile devices -->
                <span class="logo-lg">
                  <img src="/images/logo-light-text.png" alt="logo" class="light-logo">
                  <img src="/images/logo-dark-text.png" alt="logo" class="dark-logo">
              </span>
            </a>
            <!-- Header Navbar -->
            <nav class="navbar navbar-static-top">
                <!-- Sidebar toggle button-->
                <a href="#" class="d-block d-lg-none text-white" data-toggle="push-menu" role="button">
                    <span class="fa fa-bars"></span>
                </a>

                <div class="navbar-custom-menu ml-auto">
                    <ul class="nav navbar-nav">
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle text-white text-uppercase" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                @if(session()->has('lang')) {!! session()->get('lang') !!} @else ru @endisset
                            </a>
                            <div class="dropdown-menu" style="width: 60px; min-width: 0; position: relative; right: 0; top: 0;" aria-labelledby="navbarDropdown">
                                <a class="dropdown-item text-center" href="/admin?lang=ru">RU</a>
                                <a class="dropdown-item text-center" href="/admin?lang=ua">UA</a>
                            </div>
                        </li>
                        <!-- Messages -->
                        <li class="dropdown messages-menu">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                @if(isset($messages))
                                    <i class="fa fa-envelope"></i>
                                @else
                                    <i class="fa fa-envelope-open"></i>
                                @endif
                            </a>
                            <ul class="dropdown-menu scale-up">
                                <li class="header">Непрочитанные сообщений</li>
                                <li>
                                    <!-- inner menu: contains the actual data -->
                                    <ul class="menu inner-content-div">
                                        @isset($messages)
                                            @if(count($messages) > 1)
                                                @foreach($messages as $item)
                                                    <li><!-- start message -->
                                                        <a href="/admin/messages/{!! $item->id !!}">
                                                            <div class="float-left">
                                                                <img src="/images/user-mail.png" class="rounded-circle" alt="User Image">
                                                            </div>
                                                            <div class="mail-contnet">
                                                                <h4>
                                                                    {!! $item->title !!}
                                                                </h4>
                                                                <span>{!! $item->message !!}</span>
                                                            </div>
                                                        </a>
                                                    </li>
                                                @endforeach
                                            @else
                                                <li><!-- start message -->
                                                    <a href="/admin/messages/{!! $messages->first()->id !!}">
                                                        <div class="float-left">
                                                            <img src="/images/user-mail.png" class="rounded-circle" alt="User Image">
                                                        </div>
                                                        <div class="mail-contnet">
                                                            <h4>
                                                                {!! $messages->first()->title !!}
                                                            </h4>
                                                            <span>{!! $messages->first()->message !!}</span>
                                                        </div>
                                                    </a>
                                                </li>
                                            @endif
                                        @endisset
                                    </ul>
                                </li>
                                <li class="footer"><a href="/admin/messages">Просмотреть все сообщения</a></li>
                            </ul>
                        </li>
                        <!-- Notifications -->
                        <li class="site-link">
                            <a class="nav-link dropdown-toggle" href="/" target="_blank"><i class="fa fa-external-link-alt"></i></a>
                        </li>
                        <!-- User Account -->
                        <li class="dropdown user user-menu">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                <img src="/images/avatar.png" class="user-image rounded-circle" alt="User Image">
                            </a>
                            <ul class="dropdown-menu scale-up">
                                <!-- User image -->
                                <li class="user-header">
                                    <img src="/images/avatar.png" class="float-left rounded-circle" alt="User Image">

                                    <p class="text-center">
                                        Администратор
                                        <small class="mb-5">{!! $admin->email !!}</small>
                                        <a href="/admin/settings" class="btn btn-danger btn-sm btn-rounded">Настройки</a>
                                    </p>
                                </li>
                                <!-- Menu Body -->
                                <li class="user-body">
                                    <div class="row no-gutters">
                                        <div class="col-12 text-left">
                                            <a class="text-decoration-none text-black-50 rounded-0" href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                                <i class="fa fa-power-off"></i> Выйти
                                            </a>
                                            <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                                                @csrf
                                            </form>
                                        </div>
                                    </div>
                                    <!-- /.row -->
                                </li>
                            </ul>
                        </li>
                        <!-- Control Sidebar Toggle Button -->
                        <li>
                            <a href="#" data-toggle="control-sidebar"><i class="fa fa-cog fa-spin"></i></a>
                        </li>
                    </ul>
                </div>
            </nav>
        </div>
    </header>
    <!-- Main Navbar -->
    <div class="main-nav">
        <nav class="navbar navbar-expand-lg">
            <div class="collapse navbar-collapse" id="navbarNavDropdown">
                <ul class="navbar-nav">
                    <li class="nav-item @if($tag == 'home') active @endif">
                        <a class="nav-link" href="/admin">
                            <span class="active-item-here"></span><i class="fa fa-tachometer-alt mr-5"></i> <span>Статистика</span>
                        </a>
                    </li>
                    <li class="nav-item @if($tag == 'settings') active @endif">
                        <a class="nav-link" href="/admin/settings">
                            <span class="active-item-here"></span><i class="ti-settings mr-5"></i> <span>Настройки</span>
                        </a>
                    </li>
                    <li class="nav-item dropdown @if($tag == 'content') active @endif">
                        <a class="nav-link" href="/admin/content">
                            <span class="active-item-here"></span><i class="fa fa-pencil-alt mr-5"></i> <span>Основной контент</span>
                        </a>
                    </li>
                    <li class="nav-item @if($tag == 'fm') active @endif">
                        <a class="nav-link" href="/admin/fm">
                            <span class="active-item-here"></span><i class="fa fa-folder-open mr-5"></i> <span>Файловый менеджер</span>
                        </a>
                    </li>
                    <li class="nav-item dropdown @if($tag == 'products') active @endif">
                        <a class="nav-link dropdown-toggle" href="#" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <span class="active-item-here"></span><i class="fa fa-shopping-cart mr-5"></i> <span>Товары</span>
                        </a>
                        <ul class="dropdown-menu multilevel scale-up-left">
                            {{--<li class="nav-item"><a class="nav-link" href="/admin/category"><i class="fa fa-list mr-5"></i> Категории товаров</a></li>--}}
                            <li class="nav-item"><a class="nav-link" href="/admin/products"><i class="fa fa-list mr-5"></i> Список товаров</a></li>
                            <li class="nav-item"><a class="nav-link" href="/admin/products/create"><i class="fa fa-cart-plus mr-5"></i> Новый товар</a></li>
                        </ul>
                    </li>
                    <li class="nav-item dropdown @if($tag == 'articles') active @endif">
                        <a class="nav-link dropdown-toggle" href="#" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <span class="active-item-here"></span><i class="fa fa-newspaper mr-5"></i> <span>Статьи</span>
                        </a>
                        <ul class="dropdown-menu multilevel scale-up-left">
                            <li class="nav-item"><a class="nav-link" href="/admin/articles"><i class="fa fa-list mr-5"></i> Список статей</a></li>
                            <li class="nav-item"><a class="nav-link" href="/admin/manufacture"><i class="fa fa-list mr-5"></i> Маркировки</a></li>
                            <li class="nav-item"><a class="nav-link" href="/admin/articles/create"><i class="fa fa-plus mr-5"></i> Новая статья</a></li>
                            {{--<li class="nav-item"><a class="nav-link" href="/admin/comments"><i class="fa fa-comment mr-5"></i> Комментарии</a></li>--}}
                        </ul>
                    </li>
                    <li class="nav-item @if($tag == 'messages') active @endif">
                        <a class="nav-link" href="/admin/messages">
                            <span class="active-item-here"></span><i class="fa fa-envelope mr-5"></i> <span>Сообщения</span>
                        </a>
                    </li>
                    {{--<li class="nav-item @if($tag == 'order') active @endif">
                        <a class="nav-link" href="/admin/orders">
                            <span class="active-item-here"></span><i class="fa fa-cart-arrow-down mr-5"></i> <span>Заказы</span>
                        </a>
                    </li>--}}
                    {{--<li class="nav-item @if($tag == 'users') active @endif">
                        <a class="nav-link" href="/admin/users">
                            <span class="active-item-here"></span><i class="fa fa-user-friends mr-5"></i> <span>Юзеры</span>
                        </a>
                    </li>--}}
                </ul>
            </div>
        </nav>
    </div>

