

<div id="app">
    <nav class="navbar navbar-expand-md navbar-light navbar-laravel">
        <div class="container">
            Admin Panel
            <!-- Right Side Of Navbar -->
            <ul class="navbar-nav ml-auto">
                <!-- Authentication Links -->
                @guest
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('login') }}">{{ __('Login') }}</a>
                    </li>
                    @if (Route::has('register'))
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('register') }}">{{ __('Register') }}</a>
                        </li>
                    @endif
                @else
                    <li class="nav-item">
                        <a target="_blank" class="text-decoration-none mx-3 text-black-50" href="/">
                            <i class="fas fa-external-link-alt"></i>
                        </a>
                        <a class="text-decoration-none mx-3 text-black-50" href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                            Выйти
                        </a>
                        <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                            @csrf
                        </form>
                    </li>
                @endguest
            </ul>
        </div>
    </nav>
    <main class="">
        <div class="container">
            <div class="row border my-2">
                <div class="col-lg-12 my-2">
                    <div class="list-group mx-3">
                        <h2 class="text-center my-2">Настройки администратора</h2>
                        <form id="admin_form" class="settings" method="post" action="/admin">
                            @csrf
                            <input type="text" name="status" value="password" hidden>
                            <div class="row mb-2">
                                <div class="col-lg-4 text-center">
                                    <h3>Email</h3>
                                    <input type="text" name="email" value="{{$users->email}}" class="w-75 text-center">
                                </div>
                                <div class="col-lg-4 text-center">
                                    <h3>Пароль</h3>
                                    <input type="text" name="password" value="" class="w-75 text-center">
                                </div>
                                <div class="col-lg-4 text-center align-self-center">
                                    <h3>Повторить пароль</h3>
                                    <input type="text" name="password2" value="" class="w-75 text-center">
                                </div>
                            </div>
                            <div class="row mb-2 text-center mt-3">
                                <div class="col-12 mx-auto">
                                    <button type="submit" class="btn btn-primary btn-lg w-75">Сохранить изменения</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="row border my-2">
                <div class="col-lg-12 align-self-center wow fadeInLeft">
                    <div class="list-group px-3  pt-3">
                        <div class="list-group-item list-group-item-action bg-success text-white text-center">Новые сообщения</div>
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <th scope="col"  class="td-mob">№</th>
                                <th scope="col">Email</th>
                                <th scope="col" class="td-mob">Имя</th>
                                <th scope="col" class="td-mob">Сообщение</th>
                                <th scope="col" class="text-center">Удалить</th>
                            </tr>
                            </thead>
                            <tbody>
                            @if($messages != null)
                                @foreach($messages as $item)
                                    @if($item->status == '1')
                                        <tr>
                                            <td class="td-mob">
                                                <strong>{!! $item->id !!}</strong>
                                            </td>
                                            <td>
                                                <strong>{!! $item->email !!}</strong>
                                            </td>
                                            <td class="td-mob">
                                                <strong>{!! $item->name !!}</strong>
                                            </td>
                                            <td class="td-mob">
                                                <strong>{!! $item->message !!}</strong>
                                            </td>
                                            <td class="text-center">
                                                <form action="/admin" method="post">
                                                    @csrf
                                                    <input type="text" name="status" value="messages" hidden>
                                                    <input type="text" name="id" value="{!! $item->id !!}" hidden>
                                                    <button type="submit" class="btn btn-success"><i class="fas fa-trash mx-2"></i></button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endif
                                @endforeach
                            @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="row border my-2">
                <div class="col-lg-12 align-self-center wow fadeInLeft">
                    <div class="list-group px-3  pt-3">
                        <div class="list-group-item list-group-item-action bg-success text-white text-center">Заявки обратного звонка</div>
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <th scope="col"  class="td-mob">№</th>
                                <th scope="col" class="td-mob">Имя</th>
                                <th scope="col" class="td-mob">Телефон</th>
                                <th scope="col" class="td-mob">Сообщение</th>
                                <th scope="col" class="text-center">Удалить</th>
                            </tr>
                            </thead>
                            <tbody>
                            @if($tels != null)
                                @foreach($tels as $item)
                                    @if($item->status == '1')
                                        <tr>
                                            <td class="td-mob">
                                                <strong>{!! $item->id !!}</strong>
                                            </td>
                                            <td>
                                                <strong>{!! $item->name !!}</strong>
                                            </td>
                                            <td class="td-mob">
                                                <strong>{!! $item->tel !!}</strong>
                                            </td>
                                            <td class="td-mob">
                                                <strong>{!! $item->message !!}</strong>
                                            </td>
                                            <td class="text-center">
                                                <form action="/admin" method="post">
                                                    @csrf
                                                    <input type="text" name="status" value="tel" hidden>
                                                    <input type="text" name="id" value="{!! $item->id !!}" hidden>
                                                    <button type="submit" class="btn btn-success"><i class="fas fa-trash mx-2"></i></button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endif
                                @endforeach
                            @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </main>
</div>

