@extends('frontend-artlife.layouts.app')

@section('head')
    {!! $head !!}
@endsection

@section('header')
    {!! $header !!}
@endsection

@section('main')
    <div class="ogami-breadcrumb">
        <div class="container">
            <ul>
                <li><a class="breadcrumb-link" href="/"> <i class="fas fa-home"></i> Главная</a></li>
                <li>Регистрация</li>
            </ul>
        </div>
    </div>
    <!-- End breadcrumb-->
    <div class="account">
        <div class="container">
            <div class="row">
                <div class="col-12 col-md-6 mx-auto">
                    <h1 class="title">Регистрация</h1>
                    <form method="POST" action="{{ route('register') }}">
                        @csrf
                        <label for="user-name">Ваша фамилия *</label>
                        <input id="lastname" type="text" class="no-round-input" name="lastname" value="">
                        <label for="user-name">Ваше имя *</label>
                        <input id="name" type="text" class="no-round-input {{ $errors->has('name') ? ' is-invalid' : '' }}" name="name" value="{{ old('name') }}" required autofocus>
                        <label for="user-name">Ваше отчество *</label>
                        <input id="patronymic" type="text" class="no-round-input" name="patronymic" value="">
                        @if ($errors->has('name'))
                            <span class="invalid-feedback" role="alert"><strong>{{ $errors->first('name') }}</strong></span>
                        @endif
                        <label for="email">Ваш Email *</label>
                        <input id="email" type="email"
                               class="no-round-input {{ $errors->has('email') ? ' is-invalid' : '' }}"
                               name="email" value="{{ old('email') }}" required>
                        @if ($errors->has('email'))
                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $errors->first('email') }}</strong>
                                            </span>
                        @endif
                        <label for="password">Пароль *</label>
                        <input id="password" type="password"
                               class="no-round-input {{ $errors->has('password') ? ' is-invalid' : '' }}"
                               name="password" required>
                        @if ($errors->has('password'))
                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $errors->first('password') }}</strong>
                                            </span>
                        @endif
                        <label for="confirm">Повторить пароль *</label>
                        <input id="password-confirm" type="password" class="no-round-input "
                               name="password_confirmation" required>
                        <div class="account-function">
                            <button type="submit" class="no-round-btn">Зарегистрироваться</button>
                            <a class="create-account" href="/login">Авторизоваться</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footer')
    {!! $footer !!}
@endsection
