<html lang="ru">
<head>
    <meta charset="UTF-8">
    <title>CSS3 design form</title>
    <link rel="stylesheet" href="/css/home.css" type="text/css">
    <link rel="stylesheet" href="css/font-awesome.css" type="text/css">
    <style>
        body{
            background-image: url("/img/bg/fon-1.jpg");
            background-size: cover;
        }
        a{
            color: #fff;
        }
        a:hover{
            text-decoration: none;
        }
        .container{
            width:450px;
            background-color: rgba(24, 33, 52, 0.7);
            margin: 250px auto 0 auto;
            text-align: center;
            box-shadow: 0 -5px 0 #3adbfd;
            padding-bottom: 20px;
        }
        .container img{
            width:120px;
            height:120px;
            margin: -60px 0 30px 0;
            border: 5px solid #1a394f;
            border-radius: 50%;
            box-shadow: 0 -5px 0 #3adbfd;
        }

        input[type="text"],input[type="password"]{
            width: 300px;
            height:50px;
            font-size: 18px;
            margin-bottom: 25px;
            border-radius: 4px;
            padding-left: 40px;
        }
        .dws-input input:hover{
            box-shadow: 0 0 6px 3px rgba(58, 219, 253, 0.35);
        }
        .dws-submit {
            padding: 13px 30px;
            margin: 5px 0 20px 0;
            font-size: 15px;
            color: #fff;
            background-color: #2ca8c6;
            border: none;
            border-bottom: 4px solid #6ee9fd;
            cursor: pointer;
        }
        .dws-submit:hover{
            transition: all 0.5s;
            background: #fff;
            color: #2c536c;
        }

        .dws-input::before{
            font-family: "FontAwesome";
            content: "\f007";
            position: absolute;
            font-size: 30px;
            padding: 10px 0 0 7px;
            color: #2c536c;
        }
        .dws-input:nth-child(2)::before{
            content: "\f023";
        }
        .dws-input:hover::before{
            color: #319ebc;
            transition: all 0.3s;
        }
        .dws-social i{
            color: #fff;
            font-size: 20px;
            width: 20px;
            padding: 10px;
        }
        .dws-social i:hover{
            background-color: #fff;
            color: #1a394f;
            border-radius: 5px;
            cursor: pointer;
        }
    </style>
</head>
<body>
    <div class="account">
        <div class="container">
            <img src="/images/avatar.png">
            <div class="row">
                <div class="col-12" style="color: #ffffff">
                    <h1 class="title">Авторизация</h1>
                    <form action="{{ route('login') }}" method="post" style="text-align: left; padding: 30px">
                        @csrf
                        <div>
                            <input style="width: 100%; height: 50px; font-size: 18px; padding-left: 10px; border-radius: 4px;" id="email" type="email" class="no-round-input {{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email') }}" required autofocus placeholder="Email">
                            @if ($errors->has('email'))
                                <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('email') }}</strong>
                            </span>
                            @endif
                        </div>
                        <div style="margin-top: 20px;">
                            <input style="width: 100%; height: 50px; padding-left: 10px;" id="password" type="password" class="no-round-input {{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" required placeholder="Пароль">
                            @if ($errors->has('password'))
                                <span class="invalid-feedback" role="alert">
                                <strong>{{ $errors->first('password') }}</strong>
                            </span>
                            @endif
                        </div>

                        <div class="account-method" style="text-align: center; margin-top: 20px;">
                            <div class="account-save">
                                <input class="" type="checkbox" name="remember" id="basic_checkbox_1" {{ old('remember') ? 'checked' : '' }}>
                                <label for="basic_checkbox_1">Оставаться в системе</label>
                            </div>
                            {{--<div class="account-forgot"><a href="javascript:void(0)">Забыли пароль</a></div>--}}
                        </div>
                        <div class="account-function" style=" margin-top: 20px;">
                            <button type="submit" class="no-round-btn btn btn-primary" style="width: 100%; padding: 15px; font-size: 1rem;">Войти</button>
                            {{--<a class="create-account" href="/register">Создать учетную запись</a>--}}
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</body>
