
/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

//require('./bootstrap');

//window.Vue = require('vue');

/**
 * The following block of code may be used to automatically register your
 * Vue components. It will recursively scan this directory for the Vue
 * components and automatically register them with their "basename".
 *
 * Eg. ./components/ExampleComponent.vue -> <example-component></example-component>
 */

// const files = require.context('./', true, /\.vue$/i)
// files.keys().map(key => Vue.component(key.split('/').pop().split('.')[0], files(key).default))

//Vue.component('example-component', require('./components/ExampleComponent.vue').default);

/**
 * Next, we will create a fresh Vue application instance and attach it to
 * the page. Then, you may begin adding components to this application
 * or customize the JavaScript scaffolding to fit your unique needs.
 */

/*const app = new Vue({
    el: '#app'
});*/
/*====================================================================================================================*/

$.widget.bridge('uibutton', $.ui.button);

! function(window, document, $) {
    $("input,select,textarea").not("[type=submit]").jqBootstrapValidation();
}(window, document, jQuery);

function sendAjax(ajax_form, url) {
    $.ajax({
        url: url, //url страницы
        type: "POST", //метод отправки
        dataType: "html", //формат данных
        data: $("#" + ajax_form).serialize(),  // Сеарилизуем объект
        success: function(response) { //Данные отправлены успешно
            let result = $.parseJSON(response);
            if (result.text === 'save') {
                $('.alert-save').show();
                setTimeout(function() {location.reload();},2000);
            } else if (result.text === 'del') {
                $('.alert-del').show();
                setTimeout(function() {location.reload();},2000);
            } else {
                $('.alert-err').show();
                setTimeout(function() {location.reload();},2000);
            }
        },
        error: function(response) { // Данные не отправлены
            $('.alert-err').show();
            setTimeout(function() {location.reload();},2000);
        }
    });
}

$('.btn-save').click(function(e){
    e.preventDefault();
    let idForm = 'form-save-' + $(this).attr('data-id');
    let url = $('#' + idForm).attr('action');
    sendAjax(idForm, url);
    $('.btn-save').unbind('click');
    toTop();
});
$('.btn-del').click(function(e){
    e.preventDefault();
    let idForm = 'form-del-' + $(this).attr('data-id');
    let url = $('#' + idForm).attr('action');
    sendAjax(idForm, url);
    $('.btn-del').unbind('click');
    toTop();
});

// прокрутка вверх
function toTop() {
    $('body,html').animate({scrollTop:0},300);
}
/*====================================================================================================================*/
// отправка форм основного контента аяксом
$('body').on('click', '.content-save-ajax', function (e) {
    e.preventDefault();
    let idForm = $(this).attr('data-idForm');
    let url = '/admin/content';
    sendContentAjax(idForm, url);
});

function sendContentAjax(idForm, url) {
    // код подготовки формы CKEDITOR перед отправкой
    for ( instance in CKEDITOR.instances )
        CKEDITOR.instances[instance].updateElement();

    $.ajax({
        url: url, //url страницы
        type: "POST", //метод отправки
        dataType: "html", //формат данных
        data: $("#" + idForm).serialize(),  // Сеарилизуем объект
        success: function(response) { //Данные отправлены успешно
            let result = $.parseJSON(response);
            $('body,html').animate({scrollTop:0},300);
            if (result.text === 'save') {
                $('.alert-save').show();
                setTimeout(function() {$('.alert-save').hide(1000)},2000);
            } else {
                $('.alert-err').show();
                setTimeout(function() {$('.alert-err').hide(1000)},2000);
            }
        },
        error: function(response) { // Данные не отправлены
            $('body,html').animate({scrollTop:0},300);
            $('.alert-err').show();
            setTimeout(function() {$('.alert-err').hide(1000)},2000);
        }
    });
}

//вызов сообщения про сохранение после отправки данных постом
if($('.alert-save').html() != null) {
    setTimeout(function() {$('.alert-save').hide(1000)},2000);
}
if($('.alert-del').html() != null) {
    setTimeout(function() {$('.alert-del').hide(1000)},2000);
}
if($('.alert-err').html() != null) {
    setTimeout(function() {$('.alert-err').hide(1000)},2000);
}

/*====================================================================================================================*/
// дашборд для ГуглАналитики - посторение графиков и диаграмм
if(window.location.pathname === '/admin') {
    //[Dashboard Javascript]
//Project:	Fab Admin - Responsive Admin Template
//Primary use:   Used only for the main dashboard (index.html)
// Make the dashboard widgets sortable Using jquery UI
    $('.connectedSortable').sortable({
        placeholder         : 'sort-highlight',
        connectWith         : '.connectedSortable',
        handle              : '.box-header, .nav-tabs',
        forcePlaceholderSize: true,
        zIndex              : 999999
    });
    $('.connectedSortable .box-header, .connectedSortable .nav-tabs-custom').css('cursor', 'move');

// donut chart
    $('.donut').peity('donut');

// world-map


    if( $('#stat_1').length > 0 ){
        var ctx1 = document.getElementById("stat_1").getContext("2d");
        let statViews = $('#statViews').text();
        let statVisitors = $('#statVisitors').text();
        var data1 = {
            labels: ["Просмотры", "Посетители"],
            datasets: [
                {
                    label: "Статистика за сегодня",
                    backgroundColor: "#1e88e5",
                    borderColor: "#1e88e5",
                    data: [statViews, statVisitors]
                }
            ]
        };

        var hBar1 = new Chart(ctx1, {
            type:"horizontalBar",
            data:data1,

            options: {
                tooltips: {
                    mode:"label"
                },
                scales: {
                    yAxes: [{
                        stacked: true,
                        gridLines: {
                            color: "rgb(189, 181, 237)",
                        },
                        ticks: {
                            fontFamily: "Poppins",
                            fontColor:"#666666"
                        }
                    }],
                    xAxes: [{
                        stacked: true,
                        gridLines: {
                            color: "rgb(189, 181, 237)",
                        },
                        ticks: {
                            fontFamily: "Poppins",
                            fontColor:"#888888"
                        }
                    }],

                },
                elements:{
                    point: {
                        hitRadius:40
                    }
                },
                animation: {
                    duration:	3000
                },
                responsive: true,
                legend: {
                    display: false,
                },
                tooltip: {
                    backgroundColor:'rgba(33,33,33,1)',
                    cornerRadius:0,
                    footerFontFamily:"'Poppins'"
                }

            }
        });
    };

    if( $('#stat_2').length > 0 ){
        var ctx2 = document.getElementById("stat_2").getContext("2d");

        let demo11 = $('#demo1-1').text();
        let demo12 = $('#demo1-2').text();
        let demo21 = $('#demo2-1').text();
        let demo22 = $('#demo2-2').text();
        let demo31 = $('#demo3-1').text();
        let demo32 = $('#demo3-2').text();
        let demo41 = $('#demo4-1').text();
        let demo42 = $('#demo4-2').text();

        var data2 = {
            labels: [demo11, demo21, demo31, demo41],
            datasets: [
                {
                    label: "Статистика за сегодня",
                    backgroundColor: "#1e88e5",
                    borderColor: "#1e88e5",
                    data: [demo12.replace('%', ''), demo22.replace('%', ''), demo32.replace('%', ''), demo42.replace('%', '')]
                }
            ]
        };

        var hBar2 = new Chart(ctx2, {
            type:"horizontalBar",
            data:data2,

            options: {
                tooltips: {
                    mode:"label"
                },
                scales: {
                    yAxes: [{
                        stacked: true,
                        gridLines: {
                            color: "rgb(189, 181, 237)",
                        },
                        ticks: {
                            fontFamily: "Poppins",
                            fontColor:"#666666"
                        }
                    }],
                    xAxes: [{
                        stacked: true,
                        gridLines: {
                            color: "rgb(189, 181, 237)",
                        },
                        ticks: {
                            fontFamily: "Poppins",
                            fontColor:"#888888"
                        }
                    }],

                },
                elements:{
                    point: {
                        hitRadius:40
                    }
                },
                animation: {
                    duration:	3000
                },
                responsive: true,
                legend: {
                    display: false,
                },
                tooltip: {
                    backgroundColor:'rgba(33,33,33,1)',
                    cornerRadius:0,
                    footerFontFamily:"'Poppins'"
                }

            }
        });
    };


// AREA CHART

}
/*====================================================================================================================*/
// отправка формы сортировки товара
$(function() {
    $('.nice-select').change(function() {
        this.form.submit();
    });
});
