'use strict';

var assert = require('assert');
var validateOptions = require('./validate-options').default;
var schema = require('./schema').default;

describe('Validate options', function () {
  it('fails without a schema and data', function () {
    assert.throws(function () {
      validateOptions();
    }, Error);
  });

  it('fails with empty data', function () {
    var result = validateOptions(schema());

    assert.ok(!result.isValid);
    assert.ok(result.error);
  });

  it('does not fail if paths are provided', function () {
    var result = validateOptions(schema(), { paths: ['./foo'] });

    assert.ok(result.isValid);
    assert.ok(!result.error);
  });

  it('does not allow arbitrary properties', function () {
    var result = validateOptions(schema(), { paths: ['./foo'], foobar: ['./foo'] });

    assert.ok(!result.isValid);
    assert.ok(result.error);
  });

  it('styleExtensions have defaults', function () {
    var paths = ['./foo'];
    var data = { paths: paths };

    // Currently this mutates data with defaults due to ajv design. It
    // might be a good idea to change that behavior, though.
    var result = validateOptions(schema(), data);

    assert.deepEqual(data, { paths: paths, styleExtensions: ['.css'] });
    assert.ok(!result.error);
  });

  it('fails without matching path keys', function () {
    var data = {
      paths: {
        a: './foo'
      }
    };

    var result = validateOptions(schema({
      entry: {
        b: './bar'
      }
    }), data);

    assert.ok(result.error);
  });
});