'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _ajv = require('ajv');

var _ajv2 = _interopRequireDefault(_ajv);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function validateOptions(schema, data) {
  var ajv = new _ajv2.default({
    useDefaults: true, // This mutates the original data with defaults!
    errorDataPath: 'property'
  });
  var isValid = ajv.validate(schema, data);

  return {
    isValid: isValid,
    error: ajv.errors && ajv.errorsText()
  };
}

exports.default = validateOptions;