'use strict';

var path = require('path');

function searchAssets() {
  var assets = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  var extensions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

  return Object.keys(assets).map(function (name) {
    return extensions.indexOf(path.extname(name.indexOf('?') >= 0 ? name.split('?').slice(0, -1).join('') : name)) >= 0 && { name: name, asset: assets[name] };
  }).filter(function (a) {
    return a;
  });
}

function searchFiles() {
  var modules = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var extensions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
  var getter = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : function (a) {
    return a;
  };

  return Object.keys(modules).map(function (name) {
    var file = getter(modules[name]);

    if (!file) {
      return null;
    }

    return extensions.indexOf(path.extname(file)) >= 0 && file;
  }).filter(function (a) {
    return a;
  });
}

module.exports = {
  assets: searchAssets,
  files: searchFiles
};