'use strict';

var assert = require('assert');
var schema = require('./schema').default;

describe('Schema', function () {
  it('converts an object entry to validation', function () {
    var entry = {
      a: 'foo'
    };
    var result = schema({ entry: entry });
    var expected = {
      a: {
        type: ['array', 'string'],
        items: {
          type: 'string'
        }
      }
    };

    assert.deepEqual(result.properties.paths.properties, expected);
  });
});