'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
var schema = function schema() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      entry = _ref.entry;

  return {
    $schema: 'http://json-schema.org/draft-04/schema#',
    additionalProperties: false,
    type: 'object',
    properties: {
      styleExtensions: {
        type: 'array',
        items: {
          type: 'string'
        },
        default: ['.css']
      },
      minimize: {
        type: 'boolean'
      },
      moduleExtensions: {
        type: 'array',
        items: {
          type: 'string'
        }
      },
      paths: parsePaths(entry),
      purifyOptions: {
        type: 'object',
        properties: {}
      },
      verbose: {
        type: 'boolean'
      }
    },
    required: ['paths']
  };
};

function parsePaths(entry) {
  var ret = {
    type: ['array', 'object']
  };

  if (entry instanceof Object) {
    ret.additionalProperties = false;
    ret.properties = generateProperties(entry);
  } else {
    ret.items = {
      type: 'string'
    };
  }

  return ret;
}

function generateProperties(entry) {
  var ret = {};

  Object.keys(entry).forEach(function (e) {
    ret[e] = {
      type: ['array', 'string'],
      items: {
        type: 'string'
      }
    };
  });

  return ret;
}

exports.default = schema;