'use strict';

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function parseEntryPaths(paths) {
  var ret = paths || [];

  // Convert possible string to an array
  if (typeof ret === 'string') {
    return [ret];
  }

  return ret;
}

function flattenEntryPaths(paths) {
  return Array.isArray(paths) ? paths : Object.keys(paths).reduce(function (acc, val) {
    return [].concat(_toConsumableArray(acc), _toConsumableArray(paths[val]));
  }, []);
}

function parseEntries(paths, chunkName) {
  if (Array.isArray(paths)) {
    return paths;
  }

  if (!(chunkName in paths)) {
    return [];
  }

  var ret = paths[chunkName];

  return Array.isArray(ret) ? ret : [ret];
}

module.exports = {
  entryPaths: parseEntryPaths,
  flatten: flattenEntryPaths,
  entries: parseEntries
};