'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _purifyCss = require('purify-css');

var _purifyCss2 = _interopRequireDefault(_purifyCss);

var _webpackSources = require('webpack-sources');

var _parse = require('./parse');

var parse = _interopRequireWildcard(_parse);

var _search = require('./search');

var search = _interopRequireWildcard(_search);

var _validateOptions = require('./validate-options');

var _validateOptions2 = _interopRequireDefault(_validateOptions);

var _schema = require('./schema');

var _schema2 = _interopRequireDefault(_schema);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

module.exports = function PurifyPlugin(options) {
  return {
    apply: function apply(compiler) {
      var validation = (0, _validateOptions2.default)((0, _schema2.default)({
        entry: compiler.options.entry
      }), options);

      if (!validation.isValid) {
        throw new Error(validation.error);
      }

      compiler.plugin('this-compilation', function (compilation) {
        var entryPaths = parse.entryPaths(options.paths);

        parse.flatten(entryPaths).forEach(function (p) {
          if (!_fs2.default.existsSync(p)) throw new Error('Path ' + p + ' does not exist.');
        });

        // Output debug information through a callback pattern
        // to avoid unnecessary processing
        var output = options.verbose ? function (messageCb) {
          var _console;

          return (_console = console).info.apply(_console, _toConsumableArray(messageCb()));
        } : function () {};

        compilation.plugin('additional-assets', function (cb) {
          // Go through chunks and purify as configured
          compilation.chunks.forEach(function (_ref) {
            var chunkName = _ref.name,
                files = _ref.files,
                modules = _ref.modules;

            var assetsToPurify = search.assets(compilation.assets, options.styleExtensions).filter(function (asset) {
              return files.indexOf(asset.name) >= 0;
            });

            output(function () {
              return ['Assets to purify:', assetsToPurify.map(function (_ref2) {
                var name = _ref2.name;
                return name;
              }).join(', ')];
            });

            assetsToPurify.forEach(function (_ref3) {
              var name = _ref3.name,
                  asset = _ref3.asset;

              var filesToSearch = parse.entries(entryPaths, chunkName).concat(search.files(modules, options.moduleExtensions || [], function (file) {
                return file.resource;
              }));

              output(function () {
                return ['Files to search for used rules:', filesToSearch.join(', ')];
              });

              // Compile through Purify and attach to output.
              // This loses sourcemaps should there be any!
              compilation.assets[name] = new _webpackSources.ConcatSource((0, _purifyCss2.default)(filesToSearch, asset.source(), _extends({
                info: options.verbose,
                minify: options.minimize
              }, options.purifyOptions)));
            });
          });

          cb();
        });
      });
    }
  };
};