<?php

namespace App\Providers;

use Illuminate\Support\Facades\Gate;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [
        'App\Model' => 'App\Policies\ModelPolicy',
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();

        Gate::define('ADMIN', function ($user) {
            return $user->canDo('ADMIN');  //return $user->canDo(['ADMIN', 'VIEW'...], true);
        });

        Gate::define('USER', function ($user) {
            return $user->canDo('VIEW');  //return $user->canDo(['ADMIN', 'VIEW'...], true);
        });
        Gate::define('USER10', function ($user) {
            return $user->canDo('USER10');  //return $user->canDo(['ADMIN', 'VIEW'...], true);
        });
        Gate::define('USER15', function ($user) {
            return $user->canDo('USER15');  //return $user->canDo(['ADMIN', 'VIEW'...], true);
        });
        Gate::define('USER20', function ($user) {
            return $user->canDo('USER20');  //return $user->canDo(['ADMIN', 'VIEW'...], true);
        });
        Gate::define('USER25', function ($user) {
            return $user->canDo('USER25');  //return $user->canDo(['ADMIN', 'VIEW'...], true);
        });
        Gate::define('USER30', function ($user) {
            return $user->canDo('USER30');  //return $user->canDo(['ADMIN', 'VIEW'...], true);
        });
    }
}
