<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    public function manufactures()
    {
        return $this->belongsTo('App\Models\Manufacture', 'manufactures_id', 'id');
    }

    public function stocks()
    {
        return $this->belongsTo('App\Models\Stock', 'stocks_id', 'id');
    }

    public function typs()
    {
        return $this->belongsTo('App\Models\Type', 'typs_id', 'id');
    }

    protected $fillable = [
        'manufactures_id', 'stocks_id', 'typs_id', 'status', 'alias', 'title', 'description', 'h1', 'img', 'text'
    ];

    /*public function filter210()
    {
        return $this->belongsToMany('App\Models\Filter20', 'filter20_products', 'products_id', 'filter1_id');
    }*/
}
