<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    protected $table = 'categories';

    public function article()
    {
        return $this->hasMany('App\Models\Article', 'id', 'categoryID');
    }

    public function product()
    {
        return $this->hasMany('App\Models\Product', 'categoryID', 'id');
    }

    protected $fillable = [
        'parentID', 'alias', 'name', 'title', 'description'
    ];
}
