<?php

namespace App\Http\Controllers\FrontEnd;

use App\Repositories\ArticlesRepository;
use App\Repositories\ContentsRepository;
use App\Repositories\ProductsRepository;

class PageController extends FrontendController
{
    public function __construct(ProductsRepository $products, ArticlesRepository $articles, ContentsRepository $contents)
    {
        parent::__construct(new \App\Repositories\SettingsRepository(new \App\Models\Setting));
        $this->r_products = $products;
        $this->r_articles = $articles;
        $this->r_contents = $contents;
    }

    public function index()
    {
        if (isset($_GET['lang'])) {
            session()->put('lang', $_GET['lang']);
            $this->locale = 'frontend.template.'.session()->get( 'lang' ).'.';
            return back();
        }
        $path = [
                '/' => 'home',
                'about' => 'about',
                'partner' => 'partner',
                'application-1' => 'application-1',
                'application-2' => 'application-2',
                'application-3' => 'application-3',
                'application-4' => 'application-4',
        ];
        $hat = [
            '/' => '1',
            'about' => '2',
            'partner' => '3',
            'application-1' => '4',
            'application-2' => '5',
            'application-3' => '6',
            'application-4' => '7',
        ];
        $contentHead =  $this->getContentID($hat[request()->path()]);
        $tag = $path[request()->path()];
        $head = view($this->locale.'head')->with('contentHead', $contentHead)->render();
        $this->vars = array_add($this->vars, 'head', $head);
        $header = view($this->locale.'header')->with('tag', $tag)->render();
        $this->vars = array_add($this->vars, 'header', $header);
        $main = view($this->locale.'main-'.$path[request()->path()])->render();
        $this->vars = array_add($this->vars, 'main', $main);
        return $this->renderOutput();
    }

    public function store()
    {
        $search = $this->getProductSearch($_POST['search']);
        $contentHead =  $this->getContentID(8);
        $head = view($this->locale.'head')->with('contentHead', $contentHead)->render();
        $this->vars = array_add($this->vars, 'head', $head);
        $header = view($this->locale.'header')->render();
        $this->vars = array_add($this->vars, 'header', $header);
        $main = view($this->locale.'main-search')->with('search', $search)->render();
        $this->vars = array_add($this->vars, 'main', $main);
        return $this->renderOutput();
    }
}
