<?php

namespace App\Http\Controllers\FrontEnd;

use App\Repositories\ArticlesRepository;
use App\Repositories\CommentsRepository;
use App\Repositories\ContentsRepository;
use App\Repositories\ManufacturesRepository;
use App\Repositories\ProductsRepository;
use App\Repositories\StocksRepository;
use App\Repositories\TypesRepository;

class ManufactureController extends FrontendController
{
    public function __construct(ArticlesRepository $articles, CommentsRepository $comments, ContentsRepository $contents)
    {
        parent::__construct(new \App\Repositories\SettingsRepository(new \App\Models\Setting));
        $this->r_articles = $articles;
        $this->r_comments = $comments;
        $this->r_contents = $contents;

    }

    public function show($alias)
    {
        $tag = 'news';
        $article = $this->getArticleAlias($alias);
        $nameSite = $article->h1;
        $title = $article->title;
        $description = $article->description;
        $head = view($this->locale.'head')->with('title', $title)->with('description', $description)->with('nameSite', $nameSite)->render();
        $this->vars = array_add($this->vars, 'head', $head);
        $header = view($this->locale.'header')->with('tag', $tag)->render();
        $this->vars = array_add($this->vars, 'header', $header);
        $main = view($this->locale.'main-manufacture-article')->with('article', $article)->render();
        $this->vars = array_add($this->vars, 'main', $main);
        return $this->renderOutput();
    }
}
