<?php

namespace App\Http\Controllers\FrontEnd;

use App\Http\Controllers\Controller;
use App\Repositories\SectionsRepository;
use App\Repositories\SettingsRepository;

class FrontendController extends Controller
{
    protected $r_settings;
    protected $r_articles;
    protected $r_products;
    protected $r_categories;
    protected $r_contents;
    protected $r_comments;
    protected $r_users;
    protected $r_sliders;
    protected $r_sections;
    protected $r_manufactures;
    protected $r_types;
    protected $r_stocks;

    protected $locale;

    protected $template;
    protected $vars = array();

    public function __construct(SettingsRepository $settings)
    {
        $this->r_settings = $settings;
        $this->template = 'frontend.index';
        $this->middleware(function ($request, $next)
        {
            $this->locale = session()->has( 'lang' ) ? 'frontend.template.'.session()->get( 'lang' ).'.' : 'frontend.template.ru.';
            return $next($request);
        });
    }

    protected function renderOutput()
    {
        $settings = $this->getSettings();
        $footer = view($this->locale.'footer')->with('settings', $settings)->render();
        $this->vars = array_add($this->vars, 'footer', $footer);
        return view($this->template)->with($this->vars);
    }

    protected function getSettings()
    {
        $settings = $this->r_settings->get();
        return $settings->first();
    }

    protected function getCategories()
    {
        $category = $this->r_categories->get();
        return $category;
    }

    protected function getComments($article, $category)
    {
        $builder = $this->r_comments->get();
        if ($builder == null) {
            return null;
        }
        $comments = $builder->first()->where('id_post', '=', $article)->where('category', '=', $category)->where('status', '=', '1')->orderBy('id', 'DESC')->get();
        return $comments;
    }

    protected function getCategory($categoryAlias)
    {
        $category = $this->r_categories->get(['id', 'name', 'title', 'description', 'filter_name'], 1, ['alias', '=', $categoryAlias]);
        return $category->first();
    }

    protected function getSection($section)
    {
        $section = $this->r_sections->get('*', false, ['section', '=', $section]);
        if ($section != null) {
            return $section->first()->content;
        } else {
            return null;
        }
    }

    protected function getContentID($id)
    {
        $content = $this->r_contents->get('*', 1, ['id', '=', $id])->first();
        return $content;
    }

    protected function getContent()
    {
        $contents = $this->r_contents->get();
        return $contents;
    }

    protected function getSlider()
    {
        $slider = $this->r_sliders->get();
        return $slider;
    }

    protected function getArticle($categoryID)
    {
        $article = $this->r_articles->get();
        if($article == null) {
            return null;
        }
        $article = $article->first()->where('categoryID', '=', $categoryID)->orderBy('id', 'DESC')->paginate(5);
        return $article;
    }

    protected function getArticleAll($categoryID)
    {
        $article = $this->r_articles->get();
        if($article == null) {
            return null;
        }
        $article = $article->first()->where('categoryID', '=', $categoryID)->orderBy('id', 'DESC')->paginate(5);
        return $article;
    }

    protected function getArticleId($id)
    {
        $article = $this->r_articles->get()->find($id);
        return $article;
    }

    protected function getArticleAlias($alias)
    {
        $where = ['alias', '=', $alias];
        $article = $this->r_articles->get('*', 1, $where);
        if ($article == null) {
            return null;
        }
        return $article->first();
    }

    protected function getProduct($alias)
    {
        $where = ['alias', '=', $alias];
        $work = $this->r_products->get('*', 1, $where);
        if ($work == null) {
            return null;
        }
        return $work->first();
    }

    protected function getManufactures($name)
    {
        $where = ['name', '=', $name];
        $manufactures = $this->r_manufactures->get('*', 1, $where);
        if ($manufactures == null) {
            return null;
        }
        return $manufactures->first()->id;
    }

    protected function getManufacturesAll()
    {
        $manufactures = $this->r_manufactures->get();
        if ($manufactures == null) {
            return null;
        }
        return $manufactures;
    }

    protected function getProductsManufactures($manufactures)
    {
        $where = ['manufactures_id', '=', $manufactures];
        $products = $this->r_products->get('*', false, $where);
        if ($products == null) {
            return null;
        }
        return $products;
    }

    protected function getStocks($name)
    {
        $where = ['name', '=', $name];
        $stocks = $this->r_stocks->get('*', 1, $where);
        if ($stocks == null) {
            return null;
        }
        return $stocks->first()->id;
    }

    protected function getStocksAll()
    {
        $stocks = $this->r_stocks->get();
        if ($stocks == null) {
            return null;
        }
        return $stocks;
    }

    protected function getProductsStocks($stocks)
    {
        $where = ['stocks_id', '=', $stocks];
        $products = $this->r_products->get('*', false, $where);
        if ($products == null) {
            return null;
        }
        return $products;
    }

    protected function getTypes($name)
    {
        $where = ['name', '=', $name];
        $types = $this->r_types->get('*', 1, $where);
        if ($types == null) {
            return null;
        }
        return $types->first()->id;
    }

    protected function getTypesAll()
    {
        $types = $this->r_types->get();
        if ($types == null) {
            return null;
        }
        return $types;
    }

    protected function getProductsTypes($types)
    {
        $where = ['typs_id', '=', $types];
        $products = $this->r_products->get('*', false, $where);
        if ($products == null) {
            return null;
        }
        return $products;
    }
    protected function getProductSearch($search)
    {
        return $this->r_products->get()->first()->where('h1', 'like', '%'.$search.'%')->orderBy('id', 'DESC')->paginate(1000);
    }

    protected function getProducts($num)
    {
        $works = $this->r_products->get()->first()->select('id', 'categoryID', 'h1', 'alias', 'img1', 'img2', 'img3', 'created_at')->orderBy('id', 'DESC')->paginate($num);
        if ($works == null) {
            return null;
        }
        return $works;
    }

    protected function getProductsAll()
    {
        $works = $this->r_products->get()->first()->select('*')->orderBy('id', 'DESC')->get();
        if ($works == null) {
            return null;
        }
        return $works;
    }

    protected function getAdmin()
    {
        $admin = $this->r_users->get();
        return $admin->first();
    }
}
