<?php

namespace App\Http\Controllers\FrontEnd;

use App\Models\Message;
use App\Repositories\ContentsRepository;
use App\Repositories\UsersRepository;
use Illuminate\Support\Facades\Mail;

class ContactController extends FrontendController
{
    public function __construct(UsersRepository $users, ContentsRepository $contents)
    {
        parent::__construct(new \App\Repositories\SettingsRepository(new \App\Models\Setting));
        $this->r_users = $users;
        $this->r_contents = $contents;
    }

    public function index()
    {
        $contentHead = $this->getContentID(10);
        $tag = 'contact';
        $head = view($this->locale.'head')->with('contentHead', $contentHead)->render();
        $this->vars = array_add($this->vars, 'head', $head);
        $header = view($this->locale.'header')->with('tag', $tag)->render();
        $this->vars = array_add($this->vars, 'header', $header);
        $main = view($this->locale.'main-contact')->render();
        $this->vars = array_add($this->vars, 'main', $main);
        return $this->renderOutput();
    }

    public function store()
    {
        if (isset($_POST['email']) AND $_POST['email'] != '') {
            $this->createMessage($_POST);
            session()->flash('flash_message', 'Ваше сообщение отправлено успешно!');
            /*Mail::send('mail.message', ['data' => $_POST], function($message) {
                $admin = $this->getAdmin()->email;
                $data['adminEmail'] = $admin;
                $message->to($data['adminEmail'])->subject('WebTop');
                $message->from($data['adminEmail'],'Письмо / на сайте');
            });*/
            return back();
        } else {
            session()->flash('flash_error', 'Что то пошло не так! Попробуйте обратитьтся к администрации ресурса.');
            return back();
        }
    }

    public function createMessage($post)
    {
        $message = new Message($post);
        $message->save();
    }
}
