<?php

namespace App\Http\Controllers\FrontEnd;

use App\Repositories\ArticlesRepository;
use App\Repositories\ContentsRepository;
use App\Repositories\ManufacturesRepository;
use App\Repositories\ProductsRepository;
use App\Repositories\StocksRepository;
use App\Repositories\TypesRepository;

class CategoriesController extends FrontendController
{
    public function __construct(ProductsRepository $products, ManufacturesRepository $manufactures, StocksRepository $stocks, TypesRepository $types, ContentsRepository $contents)
    {
        parent::__construct(new \App\Repositories\SettingsRepository(new \App\Models\Setting));
        $this->r_products = $products;
        $this->r_manufactures = $manufactures;
        $this->r_stocks = $stocks;
        $this->r_types = $types;
        $this->r_contents = $contents;

    }

    public function index()
    {
        $path = [
            'datchiki' => 'datchiki',
            'gorelki' => 'gorelki',
            'klapan' => 'klapan',
            'preobrozovateli' => 'preobrozovateli',
            'rashodometri' => 'rashodometri',
            'chastoti' => 'chastoti',
            'iolink' => 'iolink',
            'weishaupt' => 'manufactures',
            'dinel' => 'manufactures',
            'inoxpa' => 'manufactures',
            'process-data' => 'manufactures',
            'burkert' => 'manufactures',
            'belimo' => 'manufactures',
            'ksr-kuebler' => 'manufactures',
            'wika' => 'manufactures',
            'ecolab' => 'manufactures',
            'ifm-electronic' => 'manufactures',
            'lenze' => 'manufactures',
            'Jumo' => 'manufactures',
            'samson' => 'manufactures',
            'on' => 'stocks',
            'off' => 'stocks'
        ];
        $hat = [
            'datchiki' => '11',
            'gorelki' => '12',
            'klapan' => '13',
            'preobrozovateli' => '14',
            'iolink' => '56',
        ];
        if ($path[request()->path()] == 'manufactures') {
            return redirect(request()->path().'/manufactures');
        }
        if ($path[request()->path()] == 'stocks') {
            return redirect(request()->path().'/stocks');
        }
        $contentHead =  $this->getContentID($hat[request()->path()]);
        $head = view($this->locale.'head')->with('contentHead', $contentHead)->render();
        $this->vars = array_add($this->vars, 'head', $head);
        $header = view($this->locale.'header')->render();
        $this->vars = array_add($this->vars, 'header', $header);
        $main = view($this->locale.'main-'.$path[request()->path()])->render();
        $this->vars = array_add($this->vars, 'main', $main);
        return $this->renderOutput();
    }

    public function show($category, $show)
    {
        $hat = [
            'weishaupt/'.$show => '15',
            'dinel/'.$show => '16',
            'inoxpa/'.$show => '17',
            'process-data/'.$show => '18',
            'burkert/'.$show => '19',
            'belimo/'.$show => '20',
            'ksr-kuebler/'.$show => '21',
            'wika/'.$show => '22',
            'ecolab/'.$show => '23',
            'ifm-electronic/'.$show => '24',
            'lenze/'.$show => '25',
            'jumo/'.$show => '26',
            'samson/'.$show => '27',
            'on/'.$show => '28',
            'tiporyad-w-5-40/'.$show => '29',
            'tiporyad-wm-monarch/'.$show => '30',
            'tiporyad-30-70/'.$show => '31',
            'tiporyad-wk/'.$show => '32',
            'tiporyad-wkmono/'.$show => '33',
            'datchiki-urovnya/'.$show => '34',
            'datchiki-davleniya/'.$show => '35',
            'datchiki-temperaturi/'.$show => '36',
            'induktivni-datchiki/'.$show => '37',
            'enkoderi/'.$show => '38',
            'indikatori/'.$show => '39',
            'opticheskie/'.$show => '40',
            'elektromagnityne/'.$show => '41',
            'otsechnye/'.$show => '42',
            'reguliruyuschie/'.$show => '43',
            'elektroprivodnye/'.$show => '44',
            'membrannye/'.$show => '45',
            'odnosedelnye/'.$show => '46',
            'dvuhsedelnye/'.$show => '47',
            'perepusknye/'.$show => '48',
            'klapan-batterflyaj/'.$show => '49',
            'preobrazovateli-provodimosti-1/'.$show => '50',
            'preobrazovateli-provodimosti-2/'.$show => '51',
            'preobrazovateli-provodimosti-3/'.$show => '52',
            'rashodomery/'.$show => '53',
            'preobrazovateli-chastoty/'.$show => '54',
            'io-link/'.$show => '55'
        ];
        $path = [
            'weishaupt/'.$show => 'Weishaupt',
            'dinel/'.$show => 'Dinel',
            'inoxpa/'.$show => 'Inoxpa',
            'process-data/'.$show => 'Process Data',
            'burkert/'.$show => 'Burkert',
            'belimo/'.$show => 'Belimo',
            'ksr-kuebler/'.$show => 'KSR Kuebler',
            'wika/'.$show => 'Wika',
            'ecolab/'.$show => 'Ecolab',
            'ifm-electronic/'.$show => 'IFM electronic',
            'lenze/'.$show => 'Lenze',
            'jumo/'.$show => 'Jumo',
            'samson/'.$show => 'Samson',
            'on/'.$show => 'on',
            'off/'.$show => 'off',
            'tiporyad-w-5-40/'.$show => 'Типоряд W 5—40',
            'tiporyad-wm-monarch/'.$show => 'Типоряд WM monarch',
            'tiporyad-30-70/'.$show => 'Типоряд 30—70',
            'tiporyad-wk/'.$show => 'Типоряд WK',
            'tiporyad-wkmono/'.$show => 'Типоряд WKmono',
            'datchiki-urovnya/'.$show => 'Датчики уровня',
            'datchiki-davleniya/'.$show => 'Датчики давления',
            'datchiki-temperaturi/'.$show => 'Датчики температуры',
            'induktivni-datchiki/'.$show => 'Индуктивные датчики',
            'enkoderi/'.$show => 'Энкодеры',
            'indikatori/'.$show => 'Индикаторы',
            'opticheskie/'.$show => 'Оптические датчики',
            'elektromagnityne/'.$show => 'Электромагнитыне',
            'otsechnye/'.$show => 'Отсечные',
            'reguliruyuschie/'.$show => 'Регулирующие',
            'elektroprivodnye/'.$show => 'Электроприводные',
            'membrannye/'.$show => 'Мембранные',
            'odnosedelnye/'.$show => 'Односедельны',
            'dvuhsedelnye/'.$show => 'Двухседельные',
            'perepusknye/'.$show => 'Перепускные',
            'klapan-batterflyaj/'.$show => 'Клапан-баттерфляй',
            'preobrazovateli-provodimosti-1/'.$show => 'Индуктивные измерительные преобразователи электропроводности',
            'preobrazovateli-provodimosti-2/'.$show => 'Индуктивные датчики и датчики электропроводности',
            'preobrazovateli-provodimosti-3/'.$show => 'Датчик проводимости',
            'rashodomery/'.$show => 'Расходомеры',
            'preobrazovateli-chastoty/'.$show => 'Преобразователи частоты',
            'io-link/'.$show => 'IO-Link'
        ];
        if (session()->has( 'lang' ) AND session()->get( 'lang' ) == 'ua') {
            $path = [
                'weishaupt/'.$show => 'Weishaupt',
                'dinel/'.$show => 'Dinel',
                'inoxpa/'.$show => 'Inoxpa',
                'process-data/'.$show => 'Process Data',
                'burkert/'.$show => 'Burkert',
                'belimo/'.$show => 'Belimo',
                'ksr-kuebler/'.$show => 'KSR Kuebler',
                'wika/'.$show => 'Wika',
                'ecolab/'.$show => 'Ecolab',
                'ifm-electronic/'.$show => 'IFM electronic',
                'lenze/'.$show => 'Lenze',
                'jumo/'.$show => 'Jumo',
                'samson/'.$show => 'Samson',
                'on/'.$show => 'on',
                'off/'.$show => 'off',
                'tiporyad-w-5-40/'.$show => 'Типоряд W 5—40',
                'tiporyad-wm-monarch/'.$show => 'Типоряд WM monarch',
                'tiporyad-30-70/'.$show => 'Типоряд 30—70',
                'tiporyad-wk/'.$show => 'Типоряд WK',
                'tiporyad-wkmono/'.$show => 'Типоряд WKmono',
                'datchiki-urovnya/'.$show => 'Датчики рівня',
                'datchiki-davleniya/'.$show => 'Датчики тиску',
                'datchiki-temperaturi/'.$show => 'Датчики температури',
                'induktivni-datchiki/'.$show => 'Індуктивні датчики',
                'enkoderi/'.$show => 'Енкодери',
                'indikatori/'.$show => 'Індикатори',
                'opticheskie/'.$show => 'Оптичні датчики',
                'elektromagnityne/'.$show => 'Електромагнітні',
                'otsechnye/'.$show => 'Відсічні',
                'reguliruyuschie/'.$show => 'Регулюючі',
                'elektroprivodnye/'.$show => 'Електропровідні',
                'membrannye/'.$show => 'Мембранні',
                'odnosedelnye/'.$show => 'Односідельні',
                'dvuhsedelnye/'.$show => 'Двусідельні',
                'perepusknye/'.$show => 'Перепускні',
                'klapan-batterflyaj/'.$show => 'Клапан-батерфляй',
                'preobrazovateli-provodimosti-1/'.$show => 'Індуктивні вимірювальні перетворювачі електропровідності',
                'preobrazovateli-provodimosti-2/'.$show => 'Індуктивні датчики і датчики електропровідності',
                'preobrazovateli-provodimosti-3/'.$show => 'Датчик провідності',
                'rashodomery/'.$show => 'Витратоміри',
                'preobrazovateli-chastoty/'.$show => 'Перетворювачі частоти',
                'io-link/'.$show => 'IO-Link'
            ];
        }
        $marker = 0;
        if ($show == 'manufactures') {
            $tmp = $this->getManufactures($path[request()->path()]);
            $products = $this->getProductsManufactures($tmp);
            $marker = $category;
        } elseif ($show == 'stocks') {
            $tmp = $this->getStocks($path[request()->path()]);
            $products = $this->getProductsStocks($tmp);
        } else {
            $tmp = $this->getTypes($path[request()->path()]);
            $products = $this->getProductsTypes($tmp);
        }
        if ($tmp == null) {
            return abort(404);
        }
        $h1 = $path[request()->path()];
        if ($path[request()->path()] == 'on') {
            $h1 = 'В наличии';
        }
        $contentHead =  $this->getContentID($hat[request()->path()]);
        $head = view($this->locale.'head')->with('contentHead', $contentHead)->render();
        $this->vars = array_add($this->vars, 'head', $head);
        $header = view($this->locale.'header')->render();
        $this->vars = array_add($this->vars, 'header', $header);
        $main = view($this->locale.'main-products')->with('products', $products)->with('marker', $marker)->with('h1', $h1)->render();
        $this->vars = array_add($this->vars, 'main', $main);
        return $this->renderOutput();

    }
}
