<?php

namespace App\Http\Controllers\FrontEnd;

use App\Models\Comment;
use App\Repositories\ArticlesRepository;
use App\Repositories\CommentsRepository;
use App\Repositories\ContentsRepository;

class BlogController extends FrontendController
{
    public function __construct(ArticlesRepository $articles, CommentsRepository $comments, ContentsRepository $contents)
    {
        parent::__construct(new \App\Repositories\SettingsRepository(new \App\Models\Setting));
        $this->r_articles = $articles;
        $this->r_comments = $comments;
        $this->r_contents = $contents;
    }

    public function index()
    {
        $contentHead = $this->getContentID(9);
        $tag = 'news';
        $articles = $this->getArticleAll(3);
        $head = view($this->locale.'head')->with('contentHead', $contentHead)->render();
        $this->vars = array_add($this->vars, 'head', $head);
        $header = view($this->locale.'header')->with('tag', $tag)->render();
        $this->vars = array_add($this->vars, 'header', $header);
        $main = view($this->locale.'main-news')->with('articles', $articles)->render();
        $this->vars = array_add($this->vars, 'main', $main);
        return $this->renderOutput();
    }

    public function show($alias)
    {
        $tag = 'news';
        $article = $this->getArticleAlias($alias);
        $contentHead =  $article;
        $head = view($this->locale.'head')->with('contentHead', $contentHead)->render();
        $this->vars = array_add($this->vars, 'head', $head);
        $header = view($this->locale.'header')->with('tag', $tag)->render();
        $this->vars = array_add($this->vars, 'header', $header);
        $main = view($this->locale.'main-news-article')->with('article', $article)->render();
        $this->vars = array_add($this->vars, 'main', $main);
        return $this->renderOutput();
    }

    public function store()
    {
        if (isset($_POST['comment-blog']) AND $_POST['email'] != '' AND $_POST['name'] != '' AND $_POST['comment'] != '') {
            if (isset($_POST['1'])) {
                $comment['star'] = 1;
            } elseif (isset($_POST['2'])) {
                $comment['star'] = 2;
            } elseif (isset($_POST['3'])) {
                $comment['star'] = 3;
            } elseif (isset($_POST['4'])) {
                $comment['star'] = 4;
            } else {
                $comment['star'] = 5;
            }
            $comment['category'] = 1;
            $comment['id_post'] = $_POST['id_post'];
            $comment['name'] = $_POST['name'];
            $comment['email'] = $_POST['email'];
            $comment['comment'] = $_POST['comment'];
            $this->createComment($comment);
            session()->flash('flash_message_comment', 'Ваши комментарий отправлено успешно! Он будет опубликован после проверки администратора.');
            return back();
        } elseif (isset($_POST['comment-product']) AND $_POST['email'] != '' AND $_POST['name'] != '' AND $_POST['comment'] != '') {
            if (isset($_POST['1'])) {
                $comment['star'] = 1;
            } elseif (isset($_POST['2'])) {
                $comment['star'] = 2;
            } elseif (isset($_POST['3'])) {
                $comment['star'] = 3;
            } elseif (isset($_POST['4'])) {
                $comment['star'] = 4;
            } else {
                $comment['star'] = 5;
            }
            $comment['category'] = 2;
            $comment['id_post'] = $_POST['id_post'];
            $comment['name'] = $_POST['name'];
            $comment['email'] = $_POST['email'];
            $comment['comment'] = $_POST['comment'];
            $this->createComment($comment);
            session()->flash('flash_message_comment', 'Ваши комментарий отправлено успешно! Он будет опубликован после проверки администратора.');
            return back();
        } else {
            session()->flash('flash_message_error', 'Что то пошло не так! Попробуйте обратитьтся к администрации ресурса.');
            return back();
        }
    }

    public function createComment($post)
    {
        $comment = new Comment($post);
        $comment->save();
    }
}
