<?php

namespace App\Http\Controllers\BackEnd;

use App\Repositories\MessagesRepository;
use App\Repositories\SettingsRepository;
use App\Repositories\UsersRepository;
use Illuminate\Support\Facades\Hash;

class UsersController extends BackendController
{
    public function __construct(UsersRepository $users, MessagesRepository $messages, SettingsRepository $settings)
    {
        parent::__construct();

        $this->r_users = $users;
        $this->r_messages = $messages;
        $this->r_settings = $settings;
    }

    public function index()
    {
        if(isset($_GET['trash'])) {
            $user = $this->getUsers()->find($_GET['trash']);
            if($user != null) {
                $user->roles()->detach();
                $user->delete();
            }
        }
        $messages = $this->getMessages();
        $users = $this->getUsers();
        $admin = $this->getAdmin();
        $tag = 'users';

        $header = view('backend.layouts.header')->with('tag', $tag)->with('messages', $messages)->with('admin', $admin)->render();
        $this->vars = array_add($this->vars, 'header', $header);

        $main = view('backend.layouts.mainUsers')->with('users', $users)->render();
        $this->vars = array_add($this->vars, 'main', $main);

        return $this->renderOutput();
    }

    public function store()
    {
        //dd($_POST);
        foreach ($_POST['userID'] as $n => $item) {
            $user = $this->getUsers()->find($item);
            $user->roles()->detach();
            $user->roles()->attach($_POST['role'][$n]);
        }
        session()->flash('flash_message_user', 'Вы успешно сохранили изменения!');
        return redirect('/admin/users');
    }
}
