<?php

namespace App\Http\Controllers\BackEnd;

use App\Repositories\MessagesRepository;
use App\Repositories\SettingsRepository;
use App\Repositories\TelsRepository;
use App\Repositories\UsersRepository;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;

class SettingsController extends BackendController
{
    public function __construct(UsersRepository $users, MessagesRepository $messages, SettingsRepository $settings)
    {
        parent::__construct();

        $this->r_users = $users;
        $this->r_messages = $messages;
        $this->r_settings = $settings;
    }

    public function index()
    {
        $messages = $this->getMessages();
        $admin = $this->getAdmin();
        $settings = $this->getSettings();

        $tag = 'settings';

        $header = view('backend.layouts.header')->with('tag', $tag)->with('messages', $messages)->with('admin', $admin)->render();
        $this->vars = array_add($this->vars, 'header', $header);

        $main = view('backend.layouts.mainSettings')->with('admin', $admin)->with('settings', $settings)->render();
        $this->vars = array_add($this->vars, 'main', $main);

        return $this->renderOutput();
    }

    public function store()
    {
        if ($_POST['status'] === 'admin' and $_POST['password'] != null and $_POST['password'] === $_POST['password2']) {
            $admin = $this->getAdmin();
            $admin->password = Hash::make($_POST['password']);
            $admin->email = $_POST['email'];
            $admin->save();
            session()->flash('flash_message', 'Вы успешно сохранили изменения!');
            return redirect()->back();
        } elseif ($_POST['status'] === 'google_analytics') {
            $settings = $this->getSettings();
            $settings->google_analytics = $_POST['google_analytics'];
            $settings->site = $_POST['site'];
            $settings->save();
            session()->flash('flash_message', 'Вы успешно сохранили изменения!');
            return redirect()->back();
        } elseif ($_POST['status'] === 'like') {
            $settings = $this->getSettings();
            $settings->like = $_POST['like'];
            $settings->save();
            session()->flash('flash_message', 'Вы успешно сохранили изменения!');
            return redirect()->back();
        } elseif ($_POST['status'] === 'comments') {
            $settings = $this->getSettings();
            $settings->comments = $_POST['comments'];
            $settings->save();
            session()->flash('flash_message', 'Вы успешно сохранили изменения!');
            return redirect()->back();
        } else {
            session()->flash('flash_message_err', 'Что-то пошло не так!');
            return redirect()->back();
        }
    }
}
