<?php

namespace App\Http\Controllers\BackEnd;

use App\Repositories\CategoryRepository;
use App\Repositories\ContentsRepository;
use App\Repositories\Filter1Repository;
use App\Repositories\Filter2Repository;
use App\Repositories\Filter3Repository;
use App\Repositories\Filter4Repository;
use App\Repositories\Filter5Repository;
use App\Repositories\Filter6Repository;
use App\Repositories\Filter7Repository;
use App\Repositories\Filter8Repository;
use App\Repositories\Filter9Repository;
use App\Repositories\Filter10Repository;
use App\Repositories\Filter11Repository;
use App\Repositories\Filter12Repository;
use App\Repositories\Filter13Repository;
use App\Repositories\Filter14Repository;
use App\Repositories\Filter15Repository;
use App\Repositories\Filter16Repository;
use App\Repositories\Filter17Repository;
use App\Repositories\Filter18Repository;
use App\Repositories\Filter19Repository;
use App\Repositories\Filter20Repository;
use App\Repositories\ManufacturesRepository;
use App\Repositories\MessagesRepository;
use App\Repositories\ProductsRepository;
use App\Repositories\SettingsRepository;
use App\Repositories\StocksRepository;
use App\Repositories\TelsRepository;
use App\Repositories\TypesRepository;
use App\Repositories\UsersRepository;
use DiDom\Document;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;

class ProductsController extends BackendController
{
    public function __construct(UsersRepository $users,
                                MessagesRepository $messages,
                                ProductsRepository $products,
                                CategoryRepository $category,
                                Filter1Repository $filter1,
                                Filter2Repository $filter2,
                                Filter3Repository $filter3,
                                Filter4Repository $filter4,
                                Filter5Repository $filter5,
                                Filter6Repository $filter6,
                                Filter7Repository $filter7,
                                Filter8Repository $filter8,
                                Filter9Repository $filter9,
                                Filter10Repository $filter10,
                                Filter11Repository $filter11,
                                Filter12Repository $filter12,
                                Filter13Repository $filter13,
                                Filter14Repository $filter14,
                                Filter15Repository $filter15,
                                Filter16Repository $filter16,
                                Filter17Repository $filter17,
                                Filter18Repository $filter18,
                                Filter19Repository $filter19,
                                Filter20Repository $filter20,
                                ManufacturesRepository $manufactures,
                                StocksRepository $stocks,
                                TypesRepository $types

        )
    {
        parent::__construct();

        $this->r_users = $users;
        $this->r_messages = $messages;
        $this->r_products = $products;
        $this->r_category = $category;
        $this->r_filter1 = $filter1;
        $this->r_filter2 = $filter2;
        $this->r_filter3 = $filter3;
        $this->r_filter4 = $filter4;
        $this->r_filter5 = $filter5;
        $this->r_filter6 = $filter6;
        $this->r_filter7 = $filter7;
        $this->r_filter8 = $filter8;
        $this->r_filter9 = $filter9;
        $this->r_filter10 = $filter10;
        $this->r_filter11 = $filter11;
        $this->r_filter12 = $filter12;
        $this->r_filter13 = $filter13;
        $this->r_filter14 = $filter14;
        $this->r_filter15 = $filter15;
        $this->r_filter16 = $filter16;
        $this->r_filter17 = $filter17;
        $this->r_filter18 = $filter18;
        $this->r_filter19 = $filter19;
        $this->r_filter20 = $filter20;
        $this->r_manufactures = $manufactures;
        $this->r_stocks = $stocks;
        $this->r_types = $types;
    }

    public function index()
    {
        if (!session()->has('page')) {
            session()->put('page', '1');
        }
        $page = session()->get('page');
        if(isset($_GET['page'])) {
            session()->put('page', $_GET['page']);
            $page = session()->get('page');
        }
        if (!session()->has('admin-filter'.'sort')) {
            session()->put('admin-filter'.'sort', 'all');
        }
        $sort = session()->get('admin-filter'.'sort');
        if(isset($_GET['sort'])) {
            session()->put('admin-filter'.'sort', $_GET['sort']);
            $sort = session()->get('admin-filter'.'sort');
        }
        if(isset($_GET['search'])) {
            $products = $this->getProductSearch($_GET['search']);
        } else {
            $products = $this->getProductsList($sort);
        }


        $messages = $this->getMessages();
        $admin = $this->getAdmin();

        $manufactures = $this->getManufacturesAll();

        $tag = 'products';

        $header = view('backend.layouts.header')->with('tag', $tag)->with('messages', $messages)->with('admin', $admin)->render();
        $this->vars = array_add($this->vars, 'header', $header);

        $main = view('backend.layouts.mainProductList')->with('admin', $admin)->with('products', $products)
                                                            ->with('manufactures', $manufactures)
                                                            ->with('sort', $sort)->render();
        $this->vars = array_add($this->vars, 'main', $main);

        return $this->renderOutput();
    }

    public function store()
    {
        if ($_POST['status'] === 'del') {
            $products = $this->getProducts()->find($_POST['productID']);
            $products->delete();
            session()->flash('flash_message', 'Вы успешно сохранили изменения!');
            return redirect('/admin/products');
        } elseif ($_POST['status'] === 'edit') {
            $page = session()->get('page');
            if ($_POST['alias'] == "") {
                $_POST['alias'] = $this->str2url($_POST['title']) . "-" . $_POST['productID'];
            }
            if ($_POST['img'] != "") {
                $documentImg = new Document($_POST['img']);
                $img = $documentImg->find('img')[0]->attr('src');
                $_POST['img'] = $img;
            }
            $products = $this->getProducts()->find($_POST['productID']);
            $products->manufactures_id = $_POST['manufactures_id'];
            $products->stocks_id = $_POST['stocks_id'];
            $products->typs_id = $_POST['typs_id'];
            $products->alias = $_POST['alias'];
            $products->title = $_POST['title'];
            $products->description = $_POST['description'];
            $products->h1 = $_POST['h1'];
            $products->img = $_POST['img'];
            $products->text = $_POST['text'];
            $products->save();
            session()->flash('flash_message', 'Вы успешно сохранили изменения!');
            return redirect('/admin/products'.'?page='.$page);
        } elseif ($_POST['status'] === 'create') {
            if ($_POST['img'] != "") {
                $documentImg = new Document($_POST['img']);
                $img = $documentImg->find('img')[0]->attr('src');
                $_POST['img'] = $img;
            }
            $product = $this->createProduct($_POST);
            $product2 = $this->getProducts()->find($product->id);
            $alias = "";
            if ($product->alias == "") {
                $alias = $this->str2url($product->title) . "-" . $product->id;
            }
            $product2->alias = $alias;
            $product2->save();
            session()->flash('flash_message', 'Вы успешно сохранили изменения!');
            return redirect('/admin/products');
        } else {
            session()->flash('flash_message', 'Что-то пошло не так!');
            return redirect('/admin/products');
        }
    }

    public function show($productID)
    {
        $product = $this->getProducts()->find($productID);
        $messages = $this->getMessages();
        $admin = $this->getAdmin();

        $manufactures = $this->getManufacturesAll();
        $stocks = $this->getStocksAll();
        $types = $this->getTypesAll();

        $tag = 'products';

        $header = view('backend.layouts.header')->with('tag', $tag)->with('messages', $messages)->with('admin', $admin)->render();
        $this->vars = array_add($this->vars, 'header', $header);

        $main = view('backend.layouts.mainProductEdit')->with('admin', $admin)
                                                            ->with('manufactures', $manufactures)
                                                            ->with('stocks', $stocks)
                                                            ->with('types', $types)
                                                            ->with('product', $product)
                                                            ->render();
        $this->vars = array_add($this->vars, 'main', $main);

        return $this->renderOutput();
    }

    public function create()
    {
        $messages = $this->getMessages();
        $admin = $this->getAdmin();

        $manufactures = $this->getManufacturesAll();
        $stocks = $this->getStocksAll();
        $types = $this->getTypesAll();

        $tag = 'products';

        $header = view('backend.layouts.header')->with('tag', $tag)->with('messages', $messages)->with('admin', $admin)->render();
        $this->vars = array_add($this->vars, 'header', $header);

        $main = view('backend.layouts.mainProductCreate')->with('admin', $admin)
                                                                ->with('manufactures', $manufactures)
                                                                ->with('stocks', $stocks)
                                                                ->with('types', $types)
                                                                ->render();
        $this->vars = array_add($this->vars, 'main', $main);

        return $this->renderOutput();
    }

    protected function rus2translit($string) {
        $converter = array(
            'а' => 'a',   'б' => 'b',   'в' => 'v',
            'г' => 'g',   'д' => 'd',   'е' => 'e',
            'ё' => 'e',   'ж' => 'zh',  'з' => 'z',
            'и' => 'i',   'й' => 'y',   'к' => 'k',
            'л' => 'l',   'м' => 'm',   'н' => 'n',
            'о' => 'o',   'п' => 'p',   'р' => 'r',
            'с' => 's',   'т' => 't',   'у' => 'u',
            'ф' => 'f',   'х' => 'h',   'ц' => 'c',
            'ч' => 'ch',  'ш' => 'sh',  'щ' => 'sch',
            'ь' => '',  'ы' => 'y',   'ъ' => '',
            'э' => 'e',   'ю' => 'yu',  'я' => 'ya',

            'А' => 'A',   'Б' => 'B',   'В' => 'V',
            'Г' => 'G',   'Д' => 'D',   'Е' => 'E',
            'Ё' => 'E',   'Ж' => 'Zh',  'З' => 'Z',
            'И' => 'I',   'Й' => 'Y',   'К' => 'K',
            'Л' => 'L',   'М' => 'M',   'Н' => 'N',
            'О' => 'O',   'П' => 'P',   'Р' => 'R',
            'С' => 'S',   'Т' => 'T',   'У' => 'U',
            'Ф' => 'F',   'Х' => 'H',   'Ц' => 'C',
            'Ч' => 'Ch',  'Ш' => 'Sh',  'Щ' => 'Sch',
            'Ь' => '',  'Ы' => 'Y',   'Ъ' => '',
            'Э' => 'E',   'Ю' => 'Yu',  'Я' => 'Ya',
        );
        return strtr($string, $converter);
    }
    protected function str2url($str) {
        // переводим в транслит
        $str = $this->rus2translit($str);
        // в нижний регистр
        $str = strtolower($str);
        // заменям все ненужное нам на "-"
        $str = preg_replace('~[^-a-z0-9_]+~u', '-', $str);
        // удаляем начальные и конечные '-'
        $str = trim($str, "-");
        return $str;
    }
}
