<?php

namespace App\Http\Controllers\BackEnd;

use App\Models\Product;
use App\Repositories\ProductsRepository;
use DiDom\Document;

class ParserController extends BackendController
{
    public function __construct(ProductsRepository $products)
    {
        parent::__construct();
        $this->r_products = $products;
    }

    public function index()
    {
        $host = 'https://www.ifm.com/';
        $url = 'https://www.ifm.com/ua/ru/category/055';
//        $host = 'https://www.lenze-ru.com/';
//        $url = 'https://www.lenze-ru.com/modul';
//        $host = 'http://www.dinel.cz/';
//        $url = 'http://www.dinel.cz/izdeliya/raskhodomery';
//        $host = 'http://www.jumo.ru/';
//        $url = 'http://www.jumo.ru/catalog/detail.php?ID=79';
        $path = './img/product/';
        $arrContextOptions=array(
            "ssl"=>array(
                "verify_peer"=>false,
                "verify_peer_name"=>false,
            ),
        );
        $document = new Document($url, true);
//        $articleArr = $document->find('.block-grid-xs-1.block-grid-sm-2.block-grid-md-3 div a');
//        $articleArr = $document->find('.teaser-row .large-8');
//        $articleArr = $document->find('.products_list ul li');
        $articleArr = $document->find('.block-grid-xs-1.block-grid-sm-2.block-grid-md-3>div');
//        dd($articleArr[0]->html());
        for ($i = 0; $i < count($articleArr); $i++) {
            $imgSRC = $articleArr[$i]->find('img')[0]->attr('src');
//            dd($imgSRC);
            $strImg = $this->strImg();
//            $imgNameSave = $strImg.'.jfif';
            $imgNameSave = $strImg.'.jpg';
            file_put_contents($path.$imgNameSave, file_get_contents($host.$imgSRC, false, stream_context_create($arrContextOptions)));
            $product['img'] = '/img/product/'.$imgNameSave;
            $product['h1'] = $articleArr[$i]->find('h3')[0]->text();
//            dd($product['h1']);
            $product['manufactures_id'] = 10;
            $product['stocks_id'] = 2;
            $product['typs_id'] = 25;
            $product['alias'] = $this->str2url($product['h1']) . "-" . $this->strImg(3);
            $product['title'] = $product['h1'];
            $product['description'] = 'Описание';
//            $document->first('h3')->remove();
            $product['text'] = '';//'<p>'.$articleArr[$i]->find('#4151396812 .text')[0]->innerHtml().'</p>';

//            dd($product['text']);
            $this->createProduct($product);

        }

        return 'ok';
        /*$products = $this->r_products->get();
        $text = 'Бренд аккредитован в нескольких международных системах стандарта качества.';
        foreach ($products as $item){
            $product = $this->r_products->get()->find($item->id);
            $product->description = $text;
            $product->save();
        }*/
    }

    protected function rus2translit($string) {
        $converter = array(
            'а' => 'a',   'б' => 'b',   'в' => 'v',
            'г' => 'g',   'д' => 'd',   'е' => 'e',
            'ё' => 'e',   'ж' => 'zh',  'з' => 'z',
            'и' => 'i',   'й' => 'y',   'к' => 'k',
            'л' => 'l',   'м' => 'm',   'н' => 'n',
            'о' => 'o',   'п' => 'p',   'р' => 'r',
            'с' => 's',   'т' => 't',   'у' => 'u',
            'ф' => 'f',   'х' => 'h',   'ц' => 'c',
            'ч' => 'ch',  'ш' => 'sh',  'щ' => 'sch',
            'ь' => '',  'ы' => 'y',   'ъ' => '',
            'э' => 'e',   'ю' => 'yu',  'я' => 'ya',

            'А' => 'A',   'Б' => 'B',   'В' => 'V',
            'Г' => 'G',   'Д' => 'D',   'Е' => 'E',
            'Ё' => 'E',   'Ж' => 'Zh',  'З' => 'Z',
            'И' => 'I',   'Й' => 'Y',   'К' => 'K',
            'Л' => 'L',   'М' => 'M',   'Н' => 'N',
            'О' => 'O',   'П' => 'P',   'Р' => 'R',
            'С' => 'S',   'Т' => 'T',   'У' => 'U',
            'Ф' => 'F',   'Х' => 'H',   'Ц' => 'C',
            'Ч' => 'Ch',  'Ш' => 'Sh',  'Щ' => 'Sch',
            'Ь' => '',  'Ы' => 'Y',   'Ъ' => '',
            'Э' => 'E',   'Ю' => 'Yu',  'Я' => 'Ya',
        );
        return strtr($string, $converter);
    }
    protected function str2url($str) {
        // переводим в транслит
        $str = $this->rus2translit($str);
        // в нижний регистр
        $str = strtolower($str);
        // заменям все ненужное нам на "-"
        $str = preg_replace('~[^-a-z0-9_]+~u', '-', $str);
        // удаляем начальные и конечные '-'
        $str = trim($str, "-");
        return $str;
    }

    protected function strImg($length = 15) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
}
