<?php

namespace App\Http\Controllers\BackEnd;

use App\Repositories\BriefRepository;
use App\Repositories\MessagesRepository;
use App\Repositories\UsersRepository;
use DiDom\Document;

class OrderController extends BackendController
{
    public function __construct(UsersRepository $users, MessagesRepository $messages, BriefRepository $orders)
    {
        parent::__construct();

        $this->r_users = $users;
        $this->r_messages = $messages;
        $this->r_orders = $orders;
    }

    public function index()
    {
        $messages = $this->getMessages();
        $admin = $this->getAdmin();
        $orders = $this->getOrders();
        $brief = array();
        foreach($orders as $item) {
            $brief[$item->id] = json_decode($item->brief, true);
        }
        $tag = 'order';
        $header = view('backend.layouts.header')->with('tag', $tag)->with('messages', $messages)->with('admin', $admin)->render();
        $this->vars = array_add($this->vars, 'header', $header);

        $main = view('backend.layouts.mainOrderList')->with('admin', $admin)->with('orders', $orders)->with('brief', $brief)->render();
        $this->vars = array_add($this->vars, 'main', $main);

        return $this->renderOutput();
    }

    public function show($orderID)
    {
        $orders = $this->getOrdersID()->find($orderID);
        $messages = $this->getMessages();
        $admin = $this->getAdmin();
        $brief = json_decode($orders->brief, true);
        $tag = 'order';

        $header = view('backend.layouts.header')->with('tag', $tag)->with('messages', $messages)->with('admin', $admin)->render();
        $this->vars = array_add($this->vars, 'header', $header);

        $main = view('backend.layouts.mainOrderEdit')->with('admin', $admin)->with('orders', $orders)->with('brief', $brief)->render();
        $this->vars = array_add($this->vars, 'main', $main);

        return $this->renderOutput();
    }

    public function store()
    {
        if ($_POST['status'] == 'comments') {
            $orders = $this->getOrdersID()->find($_POST['orderID']);
            $orders->comments = $_POST['comments'];
            $orders->save();
            session()->flash('flash_message', 'Вы успешно сохранили изменения!');
            return redirect('/admin/orders');
        } else {
            session()->flash('flash_message', 'Что-то пошло не так. Попробуйте отправить сообщение позже!');
            return redirect('/admin/orders');
        }

    }
}
