<?php

namespace App\Http\Controllers\BackEnd;

use App\Repositories\ContentsRepository;
use App\Repositories\MessagesRepository;
use App\Repositories\ProductsRepository;
use App\Repositories\SettingsRepository;
use App\Repositories\TelsRepository;
use App\Repositories\UsersRepository;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;

class MessagesController extends BackendController
{
    public function __construct(UsersRepository $users, MessagesRepository $messages)
    {
        parent::__construct();

        $this->r_users = $users;
        $this->r_messages = $messages;
    }

    public function index()
    {
        if(isset($_GET['status'])) {
            $messagesP = $this->getMessagesP($_GET['status']);
        } else {
            $messagesP = $this->getMessagesP();
        }
        $messages = $this->getMessages();
        $messageCount = $this->getMessagesAll();
        $admin = $this->getAdmin();

        $tag = 'messages';

        $header = view('backend.layouts.header')->with('tag', $tag)->with('messages', $messages)->with('admin', $admin)->render();
        $this->vars = array_add($this->vars, 'header', $header);

        $main = view('backend.layouts.mainMessagesList')->with('admin', $admin)->with('messagesP', $messagesP)->with('messageCount', $messageCount)->render();
        $this->vars = array_add($this->vars, 'main', $main);

        return $this->renderOutput();
    }

    public function store()
    {
        if ($_POST['status'] === 'del') {
            $message = $this->getMessageID($_POST['messageID']);
            $message->status = 3;
            $message->save();
            session()->flash('flash_message', 'Вы успешно сохранили изменения!');
            return redirect()->back();
        } elseif ($_POST['status'] === 'delAll') {
            $this->delMessagesAll();
            session()->flash('flash_message', 'Вы успешно сохранили изменения!');
            return redirect()->back();
        } elseif ($_POST['status'] === 'star') {
            $message = $this->getMessageID($_POST['messageID']);
            $message->status = 2;
            $message->save();
            session()->flash('flash_message', 'Вы успешно сохранили изменения!');
            return redirect()->back();
        } elseif ($_POST['status'] === 'star0') {
            $message = $this->getMessageID($_POST['messageID']);
            $message->status = 0;
            $message->save();
            session()->flash('flash_message', 'Вы успешно сохранили изменения!');
            return redirect()->back();
        } elseif ($_POST['status'] === 'trash') {
            $message = $this->getMessageID($_POST['messageID']);
            $message->delete();
            session()->flash('flash_message', 'Вы успешно сохранили изменения!');
            return redirect()->back();
        } else {
            session()->flash('flash_message', 'Что-то пошло не так. Попробуйте отправить сообщение позже!');
            return redirect()->back();
        }
    }

    public function show($messageID)
    {
        $messages = $this->getMessages();
        $message = $this->getMessageID($messageID);
        $messageCount = $this->getMessagesAll();
        $admin = $this->getAdmin();

        if ($message->status < 2) {
            $message->status = 0;
            $message->save();
        }

        $tag = 'messages';

        $header = view('backend.layouts.header')->with('tag', $tag)->with('messages', $messages)->with('admin', $admin)->render();
        $this->vars = array_add($this->vars, 'header', $header);

        $main = view('backend.layouts.mainMessagesEdit')->with('admin', $admin)->with('message', $message)->with('messageCount', $messageCount)->render();
        $this->vars = array_add($this->vars, 'main', $main);

        return $this->renderOutput();
    }

    protected function dataPost($result)
    {
        if(isset($_GET['status'])) {
            $messagesP = $this->getMessagesP($_GET['status']);
        } else {
            $messagesP = $this->getMessagesP();
        }
        $messages = $this->getMessages();
        $messageCount = $this->getMessagesAll();
        $admin = $this->getAdmin();

        $tag = 'messages';

        $header = view('backend.layouts.header')->with('tag', $tag)->with('messages', $messages)->with('admin', $admin)->render();
        $this->vars = array_add($this->vars, 'header', $header);

        $main = view('backend.layouts.mainMessagesList')->with('admin', $admin)->with('messagesP', $messagesP)->with('result', $result)->with('messageCount', $messageCount)->render();
        $this->vars = array_add($this->vars, 'main', $main);

        return $this->renderOutput();
    }
}
