<?php

namespace App\Http\Controllers\BackEnd;

use App\Repositories\ArticlesRepository;
use App\Repositories\CategoryRepository;
use App\Repositories\ContentsRepository;
use App\Repositories\MessagesRepository;
use App\Repositories\ProductsRepository;
use App\Repositories\SettingsRepository;
use App\Repositories\TelsRepository;
use App\Repositories\UsersRepository;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use DiDom\Document;

class ManufactureController extends BackendController
{
    public function __construct(UsersRepository $users, MessagesRepository $messages, ArticlesRepository $articles, CategoryRepository $category)
    {
        parent::__construct();

        $this->r_users = $users;
        $this->r_messages = $messages;
        $this->r_articles = $articles;
        $this->r_category = $category;
    }

    public function index()
    {
        $messages = $this->getMessages();
        $admin = $this->getAdmin();
        $articles = $this->getManufactureList();

        $tag = 'articles';

        $header = view('backend.layouts.header')->with('tag', $tag)->with('messages', $messages)->with('admin', $admin)->render();
        $this->vars = array_add($this->vars, 'header', $header);

        $main = view('backend.layouts.mainArticleList2')->with('admin', $admin)->with('articles', $articles)->render();
        $this->vars = array_add($this->vars, 'main', $main);

        return $this->renderOutput();
    }

    public function store()
    {
        if ($_POST['status'] === 'edit') {
            if ($_POST['alias'] == "") {
                $_POST['alias'] = $this->str2url($_POST['title']) . "-" . $_POST['articleID'];
            }

            $document = new Document($_POST['img']);
            $img = $document->find('img')[0]->attr('src');
            $_POST['img'] = $img;

            $article = $this->getArticles()->find($_POST['articleID']);
            $article->categoryID = $_POST['categoryID'];
            $article->alias = $_POST['alias'];
            $article->title = $_POST['title'];
            $article->description = $_POST['description'];
            $article->h1 = $_POST['h1'];
            $article->img = $_POST['img'];
            $article->text1 = $_POST['text1'];
            $article->text2 = $_POST['text2'];
            $article->save();
            session()->flash('flash_message', 'Вы успешно сохранили изменения!');
            return redirect('/admin/manufacture');
        } else {
            session()->flash('flash_message', 'Что-то пошло не так!');
            return redirect('/admin/articles');
        }
    }

    public function show($articleID)
    {
        $article = $this->getArticles()->find($articleID);
        $messages = $this->getMessages();
        $admin = $this->getAdmin();

        $categoryBlog = $this->getCategory(1);
        foreach ($categoryBlog as $item) {
            $podcategoryBlog[$item->id] = $this->getCategory($item->id);
        }

        $tag = 'articles';

        $header = view('backend.layouts.header')->with('tag', $tag)->with('messages', $messages)->with('admin', $admin)->render();
        $this->vars = array_add($this->vars, 'header', $header);

        $main = view('backend.layouts.mainArticleEdit2')->with('admin', $admin)->with('categoryBlog', $categoryBlog)
            ->with('podcategoryBlog', $podcategoryBlog)->with('article', $article)->render();
        $this->vars = array_add($this->vars, 'main', $main);

        return $this->renderOutput();
    }
}
