<?php

namespace App\Http\Controllers\BackEnd;

use App\Repositories\MessagesRepository;
use App\Repositories\SettingsRepository;
use App\Repositories\UsersRepository;
use App\Repositories\TelsRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use DiDom\Document;

class HomeController extends BackendController
{
    public function __construct(UsersRepository $users, MessagesRepository $messages, SettingsRepository $settings)
    {
        parent::__construct();

        $this->r_users = $users;
        $this->r_messages = $messages;
        $this->r_settings = $settings;
    }

    public function index()
    {
        if (isset($_GET['lang'])) {
            session()->put('lang', $_GET['lang']);
            $this->locale = 'frontend.template.'.session()->get( 'lang' ).'.';
            return back();
        }
        $settings = $this->getSettings();
        $site = $settings->site;

        $document = new Document('https://www.liveinternet.ru/stat/'.$site.'/', true);
        $document2 = new Document('https://www.liveinternet.ru/stat/'.$site.'/demo.html', true);
        $document3 = new Document('https://www.liveinternet.ru/stat/'.$site.'/browsers.html', true);
        $document4 = new Document('https://www.liveinternet.ru/stat/'.$site.'/countries.html', true);

        //в основной статистике удаляем значения уменьшения или увеличения показателя по сравнению с предыдущим днем
        if (count($document->find('table[bgcolor="#e8e8e8"] td a')) > 0) {for ($i = 0; $i < 2; $i++) {$document->first('table[bgcolor="#e8e8e8"] td a')->remove();}}

        if (isset($document->find('table[bgcolor="#e8e8e8"] td')[7]) ) {$stat['views'] = str_replace(',', '', $document->find('table[bgcolor="#e8e8e8"] td')[7]->text());} else {$stat['views'] = '';};
        if (isset($document->find('table[bgcolor="#e8e8e8"] td')[19])) {$stat['visitors'] = str_replace(',', '', $document->find('table[bgcolor="#e8e8e8"] td')[19]->text());} else {$stat['visitors'] = '';};
        if (isset($document->find('table[bgcolor="#e8e8e8"] td')[31])) {$stat['duration'] = str_replace(',', '', $document->find('table[bgcolor="#e8e8e8"] td')[31]->text());} else {$stat['duration'] = '';};
        if (isset($document->find('table[bgcolor="#e8e8e8"] td')[37])) {$stat['pages'] = str_replace(',', '', $document->find('table[bgcolor="#e8e8e8"] td')[37]->text());} else {$stat['pages'] = '';};

        if (isset($document2->find('table[bgcolor="#e8e8e8"] td')[6]) ) {$stat['demo1-1'] = $document2->find('table[bgcolor="#e8e8e8"] td')[6]->text(); } else {$stat['demo1-1'] = '';};
        if (isset($document2->find('table[bgcolor="#e8e8e8"] td')[8]) ) {$stat['demo1-2'] = $document2->find('table[bgcolor="#e8e8e8"] td')[8]->text(); } else {$stat['demo1-2'] = '';};
        if (isset($document2->find('table[bgcolor="#e8e8e8"] td')[16])) {$stat['demo2-1'] = $document2->find('table[bgcolor="#e8e8e8"] td')[16]->text();} else {$stat['demo2-1'] = '';};
        if (isset($document2->find('table[bgcolor="#e8e8e8"] td')[18])) {$stat['demo2-2'] = $document2->find('table[bgcolor="#e8e8e8"] td')[18]->text();} else {$stat['demo2-2'] = '';};
        if (isset($document2->find('table[bgcolor="#e8e8e8"] td')[26])) {$stat['demo3-1'] = $document2->find('table[bgcolor="#e8e8e8"] td')[26]->text();} else {$stat['demo3-1'] = '';};
        if (isset($document2->find('table[bgcolor="#e8e8e8"] td')[28])) {$stat['demo3-2'] = $document2->find('table[bgcolor="#e8e8e8"] td')[28]->text();} else {$stat['demo3-2'] = '';};
        if (isset($document2->find('table[bgcolor="#e8e8e8"] td')[36])) {$stat['demo4-1'] = $document2->find('table[bgcolor="#e8e8e8"] td')[36]->text();} else {$stat['demo4-1'] = '';};
        if (isset($document2->find('table[bgcolor="#e8e8e8"] td')[38])) {$stat['demo4-2'] = $document2->find('table[bgcolor="#e8e8e8"] td')[38]->text();} else {$stat['demo4-2'] = '';};

        if (isset($document3->find('table[bgcolor="#e8e8e8"] td')[6]))  {$stat['browsers11'] = $document3->find('table[bgcolor="#e8e8e8"] td')[6]->text(); } else {$stat['browsers11'] = '';};
        if (isset($document3->find('table[bgcolor="#e8e8e8"] td')[8]))  {$stat['browsers12'] = $document3->find('table[bgcolor="#e8e8e8"] td')[8]->text(); } else {$stat['browsers12'] = '';};
        if (isset($document3->find('table[bgcolor="#e8e8e8"] td')[9]))  {$stat['browsers13'] = $document3->find('table[bgcolor="#e8e8e8"] td')[9]->text(); } else {$stat['browsers13'] = '';};
        if (isset($document3->find('table[bgcolor="#e8e8e8"] td')[16])) {$stat['browsers21'] = $document3->find('table[bgcolor="#e8e8e8"] td')[16]->text();} else {$stat['browsers21'] = '';};
        if (isset($document3->find('table[bgcolor="#e8e8e8"] td')[18])) {$stat['browsers22'] = $document3->find('table[bgcolor="#e8e8e8"] td')[18]->text();} else {$stat['browsers22'] = '';};
        if (isset($document3->find('table[bgcolor="#e8e8e8"] td')[19])) {$stat['browsers23'] = $document3->find('table[bgcolor="#e8e8e8"] td')[19]->text();} else {$stat['browsers23'] = '';};
        if (isset($document3->find('table[bgcolor="#e8e8e8"] td')[26])) {$stat['browsers31'] = $document3->find('table[bgcolor="#e8e8e8"] td')[26]->text();} else {$stat['browsers31'] = '';};
        if (isset($document3->find('table[bgcolor="#e8e8e8"] td')[28])) {$stat['browsers32'] = $document3->find('table[bgcolor="#e8e8e8"] td')[28]->text();} else {$stat['browsers32'] = '';};
        if (isset($document3->find('table[bgcolor="#e8e8e8"] td')[29])) {$stat['browsers33'] = $document3->find('table[bgcolor="#e8e8e8"] td')[29]->text();} else {$stat['browsers33'] = '';};

        if (isset($document4->find('input[value="перестроить график"]')[0])) {$document4->find('input[value="перестроить график"]')[0]->remove();};
        $stat['countries'] = $document4->find('table[bgcolor="#e8e8e8"]');

        //dd($posts);

        $messages = $this->getMessages();
        $admin = $this->getAdmin();
        $users = $this->getUsers();

        $tag = 'home';

        $header = view('backend.layouts.header')->with('tag', $tag)->with('admin', $admin)->with('messages', $messages)->render();
        $this->vars = array_add($this->vars, 'header', $header);

        $main = view('backend.layouts.mainHome')->with('messages', $messages)->with('stat', $stat)->with('users', $users)->render();
        $this->vars = array_add($this->vars, 'main', $main);

        return $this->renderOutput();
    }

    public function store()
    {
        if ($_POST['status'] == 'password') {
            if ($_POST['password'] == $_POST['password2']) {
                $admin = $this->getUsers();
                $admin->password = Hash::make($_POST['password']);
                $admin->email = $_POST['email'];
                $admin->save();
                return redirect("/admin");
            } else {
                back();
            }
        } elseif ($_POST['status'] == 'messages') {
            $message = $this->getMessages()->find($_POST['id']);
            $message->status = '2';
            $message->save();
            return redirect("/admin");
        } elseif ($_POST['status'] == 'tel') {
            $tel = $this->getTels()->find($_POST['id']);
            $tel->status = '2';
            $tel->save();
            return redirect("/admin");
        }
        return abort(404);
    }
}
