<?php

namespace App\Http\Controllers\BackEnd;

use App\Repositories\ContentsRepository;
use App\Repositories\MessagesRepository;
use App\Repositories\SettingsRepository;
use App\Repositories\TelsRepository;
use App\Repositories\UsersRepository;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;

class FmController extends BackendController
{
    public function __construct(UsersRepository $users, MessagesRepository $messages)
    {
        parent::__construct();

        $this->r_users = $users;
        $this->r_messages = $messages;
    }

    public function index()
    {
        $messages = $this->getMessages();
        $admin = $this->getAdmin();

        $tag = 'fm';

        $header = view('backend.layouts.header')->with('tag', $tag)->with('messages', $messages)->with('admin', $admin)->render();
        $this->vars = array_add($this->vars, 'header', $header);

        $main = view('backend.layouts.mainFM')->render();
        $this->vars = array_add($this->vars, 'main', $main);

        return $this->renderOutput();
    }
}
