<?php

namespace App\Http\Controllers\BackEnd;

use App\Models\Faq;
use App\Repositories\FaqRepository;
use App\Repositories\MessagesRepository;
use App\Repositories\SettingsRepository;
use App\Repositories\TelsRepository;
use App\Repositories\UsersRepository;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;

class FaqController extends BackendController
{
    public function __construct(UsersRepository $users, MessagesRepository $messages, FaqRepository $faq)
    {
        parent::__construct();

        $this->r_users = $users;
        $this->r_messages = $messages;
        $this->r_faq = $faq;
    }

    public function index()
    {
        $messages = $this->getMessages();
        $admin = $this->getAdmin();
        $faq = $this->getFaq();

        $tag = 'faq';

        $header = view('backend.layouts.header')->with('messages', $messages)->with('tag', $tag)->with('admin', $admin)->render();
        $this->vars = array_add($this->vars, 'header', $header);

        $main = view('backend.layouts.mainFAQ')->with('faq', $faq)->render();
        $this->vars = array_add($this->vars, 'main', $main);

        return $this->renderOutput();
    }

    public function store()
    {
        //dd($_POST);
        if ($_POST['status'] === 'new' and $_POST['question'] != null and $_POST['text'] != null) {
            $this->createFaq($_POST);
            $result = array(
                'text' => 'save',
            );
            return json_encode($result);
        } elseif ($_POST['status'] === 'del') {
            $this->delFaq($_POST['id']);
            $result = array(
                'text' => 'del',
            );
            return json_encode($result);
        } else {
            $result = array(
                'text' => 'err',
            );
            return json_encode($result);
        }
    }

    public function createFaq($post)
    {
        $faq = new Faq($post);
        $faq->save();
    }

    public function delFaq($post)
    {
        $faq = $this->r_faq->get()->find($post);
        return $faq->delete();
    }
}
