<?php

namespace App\Http\Controllers\BackEnd;

use App\Models\Slider;
use App\Repositories\ArticlesRepository;
use App\Repositories\CategoryRepository;
use App\Repositories\ProductsRepository;
use App\Repositories\ContentsRepository;
use App\Repositories\MessagesRepository;
use App\Repositories\SectionsRepository;
use App\Repositories\SettingsRepository;
use App\Repositories\SlidersRepository;
use App\Repositories\Sliders2Repository;
use App\Repositories\TelsRepository;
use App\Repositories\TitlesRepository;
use App\Repositories\UsersRepository;
use DiDom\Document;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;

class ContentController extends BackendController
{
    public function __construct(UsersRepository $users, MessagesRepository $messages, ContentsRepository $contents,
                                ArticlesRepository $articles, CategoryRepository $category, SlidersRepository $sliders, SectionsRepository $sections)
    {
        parent::__construct();

        $this->r_users = $users;
        $this->r_messages = $messages;
        $this->r_contents = $contents;
        $this->r_articles = $articles;
        $this->r_category = $category;
        $this->r_sliders = $sliders;
        $this->r_sections = $sections;
    }

    public function index()
    {
        $messages = $this->getMessages();
        $admin = $this->getAdmin();
        $tag = 'content';
// обход по папкам шаблона и сбор все информации в одну
        $localTem = session()->has( 'lang' ) ? session()->get( 'lang' ) : 'ru';
        $dir = Storage::disk($localTem)->files();
        array_shift($dir);
        unset($dir[0]);
        unset($dir[14]);
        unset($dir[15]);
        foreach ($dir as $num => $item) {
            $file[$item] = new Document(Storage::disk($localTem)->get($item));
        }
        $textArray = null;
        $imgArray = null;
        $htmlArray = null;
        foreach ($file as $name => $item) {
            $text = $item->find('*[data-blade=text]');
            foreach ($text as $i => $code) {
                $textArray[$name][$i] = $code->innerHtml();
            }
            $html = $item->find('*[data-blade=html]');
            foreach ($html as $i => $code) {
                $htmlArray[$name][$i] = $code->innerHtml();
            }
            $img = $item->find('img');
            foreach ($img as $i => $code) {
                $imgArray[$name][$i] = $code->html();
            }
        }
// конец сбора информации для дальнейших правок в админке
        $contentHead =  $this->getContentID();
        $header = view('backend.layouts.header')->with('tag', $tag)->with('messages', $messages)->with('admin', $admin)->render();
        $this->vars = array_add($this->vars, 'header', $header);
        $main = view('backend.layouts.mainContent')->with('admin', $admin)
                                                        ->with('dir', $dir)
                                                        ->with('textArray', $textArray)
                                                        ->with('htmlArray', $htmlArray)
                                                        ->with('imgArray', $imgArray)
                                                        ->with('contentHead', $contentHead)
                                                        ->render();
        $this->vars = array_add($this->vars, 'main', $main);
        return $this->renderOutput();
    }

    public function store()
    {
        $localTem = session()->has( 'lang' ) ? session()->get( 'lang' ) : 'ru';
        if (isset($_POST)) {
            if (isset($_POST['status']) AND $_POST['status'] == 111) {
                $seo = $this->getContents();
                foreach ($seo as $num =>$item) {
                    $item->title = $_POST['seo-title-'.$item->id];
                    $item->description = $_POST['seo-description-'.$item->id];
                    $item->save();
                }
            } else {
                $file = new Document(Storage::disk($localTem)->get($_POST['status']));
                if (isset($_POST['textArray'])) {
                    foreach ($_POST['textArray'] as $i => $item) {
                        $file->find('*[data-blade=text]')[$i]->setInnerHtml($item);
                    }
                }
                if (isset($_POST['htmlArray'])) {
                    foreach ($_POST['htmlArray'] as $i => $item) {
                        $file->find('*[data-blade=html]')[$i]->setInnerHtml($item);
                    }
                }
                if (isset($_POST['imgArray'])) {
                    foreach ($_POST['imgArray'] as $i => $item) {
                        if ($item != '') {
                            $img = new Document($item);
                            $src = $img->find('img')[0]->attr('src');
                            if (isset($file->find('img')[$i])) {
                                $file->find('img')[$i]->setAttribute('src', $src);
                            }
                        }
                    }
                }
                Storage::disk($localTem)->put($_POST['status'], html_entity_decode($file->find('body')[0]->innerHtml()));
            }
            session()->flash('flash_message', 'Вы успешно внесли изменения!');
            return back();
        } else {
            session()->flash('flash_message_error', 'Что то пошло не так!');
            return back();
        }
    }
}
