<?php

namespace App\Http\Controllers\BackEnd;

use App\Repositories\ArticlesRepository;
use App\Repositories\CategoryRepository;
use App\Repositories\CommentsRepository;
use App\Repositories\ContentsRepository;
use App\Repositories\MessagesRepository;
use App\Repositories\ProductsRepository;
use App\Repositories\SettingsRepository;
use App\Repositories\TelsRepository;
use App\Repositories\UsersRepository;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use DiDom\Document;

class CommentsController extends BackendController
{
    public function __construct(UsersRepository $users,
                                MessagesRepository $messages,
                                CommentsRepository $comments,
                                CategoryRepository $category,
                                ArticlesRepository $articles,
                                ProductsRepository $products)
    {
        parent::__construct();

        $this->r_users = $users;
        $this->r_messages = $messages;
        $this->r_comments = $comments;
        $this->r_category = $category;
        $this->r_articles = $articles;
        $this->r_products = $products;
    }

    public function index()
    {
        $messages = $this->getMessages();
        $admin = $this->getAdmin();
        $comments = $this->getComments();
        $aliasArticle = array();
        $aliasProduct = array();
        if ($comments != null) {
            foreach ($comments as $item) {
                if ($item->category == 1) {
                    $aliasArticle[$item->id_post] = '/' . $this->getArticles()->find($item->id_post)->category->alias . '/' . $this->getArticles()->find($item->id_post)->alias;
                } elseif ($item->category == 2) {
                    $aliasProduct[$item->id_post] = '/' . $this->getProducts()->find($item->id_post)->category->alias . '/' . $this->getProducts()->find($item->id_post)->alias;
                }
            }
        }

        $tag = 'articles';

        $header = view('backend.layouts.header')->with('tag', $tag)->with('messages', $messages)->with('admin', $admin)->render();
        $this->vars = array_add($this->vars, 'header', $header);

        $main = view('backend.layouts.mainComments')->with('admin', $admin)->with('comments', $comments)->with('aliasArticle', $aliasArticle)->with('aliasProduct', $aliasProduct)->render();
        $this->vars = array_add($this->vars, 'main', $main);

        return $this->renderOutput();
    }

    public function store()
    {
        if ($_POST['status'] === 'del') {
            $comment = $this->getComments()->find($_POST['commentID']);
            $comment->delete();
            session()->flash('flash_message', 'Вы успешно удалили комментарий!');
            return redirect('/admin/comments');
        } elseif ($_POST['status'] === 'edit') {
            $comment = $this->getComments()->find($_POST['commentID']);
            $comment->status = 1;
            $comment->save();
            session()->flash('flash_message', 'Вы успешно опубликовали комментарий!');
            return redirect('/admin/comments');
        } else {
            session()->flash('flash_message', 'Что-то пошло не так!');
            return redirect('/admin/articles');
        }
    }
}
