<?php

namespace App\Http\Controllers\BackEnd;

use App\Repositories\CategoryRepository;
use App\Repositories\ContentsRepository;
use App\Repositories\MessagesRepository;
use App\Repositories\ProductsRepository;
use App\Repositories\SettingsRepository;
use App\Repositories\TelsRepository;
use App\Repositories\UsersRepository;
use DiDom\Document;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;

class CategoryController extends BackendController
{
    public function __construct(UsersRepository $users, MessagesRepository $messages, CategoryRepository $category)
    {
        parent::__construct();

        $this->r_users = $users;
        $this->r_messages = $messages;
        $this->r_category = $category;
    }

    public function index()
    {
        $messages = $this->getMessages();
        $admin = $this->getAdmin();
        $category = $this->getCategory(2);
        if($category != null) {
            foreach ($category as $item) {
                $podcategory[$item->id] = $this->getCategory($item->id);
            }
        } else {
            $podcategory = null;
        }

        $tag = 'products';

        $header = view('backend.layouts.header')->with('tag', $tag)->with('messages', $messages)->with('admin', $admin)->render();
        $this->vars = array_add($this->vars, 'header', $header);

        $main = view('backend.layouts.mainCategoryList')->with('admin', $admin)->with('category', $category)
            ->with('podcategory', $podcategory)->render();
        $this->vars = array_add($this->vars, 'main', $main);

        return $this->renderOutput();
    }



    public function store()
    {
        if ($_POST['status'] === 'del') {
            try
            {
                $categoryEdit = $this->getCategoryID($_POST['categoryID']);
                $categoryEdit->delete();
                session()->flash('flash_message', 'Вы успешно сохранили изменения!');
                return redirect('/admin/category');
            }
            catch(\Exception $e)
            {
                session()->flash('flash_message', 'Вы не можете удалить категорию товаров в которой существуют товары');
                return redirect('/admin/category');
            }

        } elseif ($_POST['status'] === 'edit') {
            if ($_POST['alias'] == "") {
                $_POST['alias'] = $this->str2url($_POST['name']) . "-" . $_POST['categoryID'];
            }
            $categoryEdit = $this->getCategoryID($_POST['categoryID']);
            $categoryEdit->parentID = $_POST['parentID'];
            $categoryEdit->name = $_POST['name'];
            $categoryEdit->alias = $_POST['alias'];
            $categoryEdit->title = $_POST['title'];
            $categoryEdit->description = $_POST['description'];
            $categoryEdit->save();
            session()->flash('flash_message', 'Вы успешно сохранили изменения!');
            return redirect('/admin/category');
        } elseif ($_POST['status'] === 'create') {
            $category = $this->createCategory($_POST);
            $category2 = $this->getCategoryID($category->id);
            $alias = "";
            if ($category->alias == "") {
                $alias = $this->str2url($category->name) . "-" . $category->id;
            }
            $category2->alias = $alias;
            $category2->save();
            session()->flash('flash_message', 'Вы успешно сохранили изменения!');
            return redirect('/admin/category');
        } else {
            session()->flash('flash_message', 'Что-то пошло не так!');
            return redirect('/admin/category');
        }
    }

    public function show($categoryID)
    {
        $messages = $this->getMessages();
        $admin = $this->getAdmin();
        $categoryEdit = $this->getCategoryID($categoryID);
        $category = $this->getCategory(2);
        if($category != null) {
            foreach ($category as $item) {
                $podcategory[$item->id] = $this->getCategory($item->id);
            }
        } else {
            $podcategory = null;
        }

        $tag = 'products';

        $header = view('backend.layouts.header')->with('tag', $tag)->with('messages', $messages)->with('admin', $admin)->render();
        $this->vars = array_add($this->vars, 'header', $header);

        $main = view('backend.layouts.mainCategoryEdit')->with('admin', $admin)->with('category', $category)
            ->with('categoryEdit', $categoryEdit)->with('podcategory', $podcategory)->render();
        $this->vars = array_add($this->vars, 'main', $main);

        return $this->renderOutput();
    }

    public function create()
    {
        $messages = $this->getMessages();
        $admin = $this->getAdmin();
        $category = $this->getCategory(2);
        if($category != null) {
            foreach ($category as $item) {
                $podcategory[$item->id] = $this->getCategory($item->id);
            }
        } else {
            $podcategory = null;
        }

        $tag = 'products';

        $header = view('backend.layouts.header')->with('tag', $tag)->with('messages', $messages)->with('admin', $admin)->render();
        $this->vars = array_add($this->vars, 'header', $header);

        $main = view('backend.layouts.mainCategoryCreate')->with('admin', $admin)->with('category', $category)
            ->with('podcategory', $podcategory)->render();
        $this->vars = array_add($this->vars, 'main', $main);

        return $this->renderOutput();
    }

    protected function rus2translit($string) {
        $converter = array(
            'а' => 'a',   'б' => 'b',   'в' => 'v',
            'г' => 'g',   'д' => 'd',   'е' => 'e',
            'ё' => 'e',   'ж' => 'zh',  'з' => 'z',
            'и' => 'i',   'й' => 'y',   'к' => 'k',
            'л' => 'l',   'м' => 'm',   'н' => 'n',
            'о' => 'o',   'п' => 'p',   'р' => 'r',
            'с' => 's',   'т' => 't',   'у' => 'u',
            'ф' => 'f',   'х' => 'h',   'ц' => 'c',
            'ч' => 'ch',  'ш' => 'sh',  'щ' => 'sch',
            'ь' => '',  'ы' => 'y',   'ъ' => '',
            'э' => 'e',   'ю' => 'yu',  'я' => 'ya',

            'А' => 'A',   'Б' => 'B',   'В' => 'V',
            'Г' => 'G',   'Д' => 'D',   'Е' => 'E',
            'Ё' => 'E',   'Ж' => 'Zh',  'З' => 'Z',
            'И' => 'I',   'Й' => 'Y',   'К' => 'K',
            'Л' => 'L',   'М' => 'M',   'Н' => 'N',
            'О' => 'O',   'П' => 'P',   'Р' => 'R',
            'С' => 'S',   'Т' => 'T',   'У' => 'U',
            'Ф' => 'F',   'Х' => 'H',   'Ц' => 'C',
            'Ч' => 'Ch',  'Ш' => 'Sh',  'Щ' => 'Sch',
            'Ь' => '',  'Ы' => 'Y',   'Ъ' => '',
            'Э' => 'E',   'Ю' => 'Yu',  'Я' => 'Ya',
        );
        return strtr($string, $converter);
    }
    protected function str2url($str) {
        // переводим в транслит
        $str = $this->rus2translit($str);
        // в нижний регистр
        $str = strtolower($str);
        // заменям все ненужное нам на "-"
        $str = preg_replace('~[^-a-z0-9_]+~u', '-', $str);
        // удаляем начальные и конечные '-'
        $str = trim($str, "-");
        return $str;
    }
}
