<?php

namespace App\Http\Controllers\BackEnd;

use App\Models\Article;
use App\Models\Category;
use App\Models\Product;
use Gate;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use App\Repositories\SettingsRepository;

class BackendController extends Controller
{
    protected $r_orders;
    protected $r_role;
    protected $r_settings;
    protected $r_messages;
    protected $r_comments;
    protected $r_users;
    protected $r_faq;
    protected $r_contents;
    protected $r_articles;
    protected $r_sliders;
    protected $r_titles;
    protected $r_category;
    protected $r_sections;
    protected $r_manufactures;
    protected $r_types;
    protected $r_stocks;
    protected $r_products;


    protected $locale;
    protected $template = 'backend.index';
    protected $vars = array();

    public function __construct()
    {
        $this->middleware(function ($request, $next)
        {
            $this->locale = session()->has( 'lang' ) ? 'frontend.template.'.session()->get( 'lang' ).'.' : 'frontend.template.ru.';
            return $next($request);
        });
    }

    protected function renderOutput()
    {
        if (Gate::denies('ADMIN')) {
            abort(403);
        }
        $footer = view('backend.layouts.footer')->render();
        $this->vars = array_add($this->vars, 'footer', $footer);
        return view($this->template)->with($this->vars);
    }

    protected function getSection()
    {
        $section = $this->r_sections->get();
        if ($section != null) {
            return $section;
        } else {
            return null;
        }
    }

    protected function getSettings()
    {
        $settings = $this->r_settings->get();
        return $settings->first();
    }

    protected function getTitles()
    {
        $titles = $this->r_titles->get();
        return $titles;
    }

    protected function getMessages()
    {
        $where = ['status', '=', 1];
        $messages = $this->r_messages->get('*', 5, $where);
        if ($messages) {
            return $messages;
        }
        return null;
    }

    protected function getMessageID($messageID)
    {
        $messages = $this->r_messages->get()->first()->find($messageID);
        return $messages;
    }

    protected function getMessagesP($get = false)
    {
        $tmp = $this->r_messages->get();
        if ($tmp != null) {
            if($get) {
                $messages = $this->r_messages->get()->first()->where('status', '=', $get )->paginate(50);
            } else {
                $messages = $this->r_messages->get()->first()->where('status', '<', 2 )->paginate(50);
            }
        } else {
            $messages = null;
        }
        return $messages;
    }

    protected function getMessagesAll()
    {
        $tmp = $this->r_messages->get();
        if ($tmp != null) {
            $messages['1'] = $this->r_messages->get()->first()->where('status', '<', 2)->count();
            $messages['2'] = $this->r_messages->get()->first()->where('status', '=', 2)->count();
            $messages['3'] = $this->r_messages->get()->first()->where('status', '=', 3)->count();
        } else {
            $messages = null;
        }
        return $messages;
    }

    protected function delMessagesAll()
    {
        $tmp = $this->r_messages->get();
        if ($tmp != null) {
            $messages = $this->r_messages->get()->first()->where('status', '<', 5)->delete();
        } else {
            $messages = null;
        }
        return $messages;
    }

    protected function getAdmin()
    {
        $admin = $this->r_users->get();
        return $admin->first();
    }

    protected function getUsers()
    {
        $users = $this->r_users->get();
        return $users;
    }

    protected function getFaq()
    {
        $faq = $this->r_faq->get();
        return $faq;
    }

    protected function getContents()
    {
        $contents = $this->r_contents->get();
        return $contents;
    }

    protected function getContentsID($id)
    {
        $content = $this->r_contents->get()->find($id);
        return $content;
    }

    protected function getSliders()
    {
        $sliders = $this->r_sliders->get();
        return $sliders;
    }

    protected function getArticles()
    {
        $articles = $this->r_articles->get();
        return $articles;
    }

    protected function getArticlesList()
    {
        $tmp = $this->r_articles->get();
        if ($tmp != null) {
            $articles = $this->r_articles->get()->first()->whereIn('categoryID', [3, 9, 10, 11, 12, 13, 14, 15, 16])->orderBy('id', 'DESC')->paginate(50);
        } else {
            $articles = null;
        }
        return $articles;
    }

    protected function getContentID()
    {
        $content = $this->r_contents->get();
        return $content;
    }

    protected function getManufactureList()
    {
        $tmp = $this->r_articles->get();
        if ($tmp != null) {
            $articles = $this->r_articles->get()->first()->whereIn('categoryID', [4,])->orderBy('id', 'DESC')->paginate(50);
        } else {
            $articles = null;
        }
        return $articles;
    }

    protected function getComments()
    {
        $tmp = $this->r_comments->get();
        if ($tmp != null) {
            $comments = $this->r_comments->get()->first()->orderBy('id', 'DESC')->paginate(50);
        } else {
            $comments = null;
        }
        return $comments;
    }

    protected function getProducts()
    {
        $products = $this->r_products->get();
        return $products;
    }

    protected function getProductsList($sort)
    {
        $tmp = $this->r_products->get();
        if ($tmp != null) {
            if ($sort == 'all') {
                $product = $this->r_products->get()->first()->orderBy('id', 'DESC')->paginate(10);
            } else {
                $product = $this->r_products->get()->first()->where('manufactures_id', '=', $sort)->orderBy('id', 'DESC')->paginate(10);
            }
        } else {
            $product = null;
        }
        return $product;
    }

    protected function getProductSearch($search)
    {
        return $this->r_products->get()->first()->where('h1', 'like', '%'.$search.'%')->orderBy('id', 'DESC')->paginate(1000);
    }

    protected function getProductsListTop()
    {
        $tmp = $this->r_products->get();
        if ($tmp != null) {
            $product = $this->r_products->get()->where('status', '>', '0');
        } else {
            $product = null;
        }
        return $product;
    }

    protected function createProduct($post)
    {
        unset($post['status']);
        $product = new Product($post);
        if (session()->get( 'lang' ) == 'ua') {
            $product->setConnection('mysqlUA');
        }
        $product->save();
        return $product;
    }

    protected function createArticle($post)
    {
        $article = new Article($post);
        if (session()->get( 'lang' ) == 'ua') {
            $article->setConnection('mysqlUA');
        }
        $article->save();
        return $article;
    }

    protected function getCategory($parentID)
    {
        $where = ['parentID', '=', $parentID];
        $category = $this->r_category->get('*', FALSE, $where);
        return $category;
    }

    protected function getCategoryID($categoryID)
    {
        $category = $this->r_category->get()->find($categoryID);
        return $category;
    }

    protected function createCategory($post)
    {
        $category = new Category($post);
        $category->save();
        return $category;
    }

    protected function getOrders()
    {
        $tmp = $this->r_orders->get();
        if ($tmp != null) {
            $orders = $this->r_orders->get()->first()->orderBy('id', 'DESC')->paginate(20);
        } else {
            $orders = null;
        }
        return $orders;
    }
    protected function getOrdersID()
    {
        $tmp = $this->r_orders->get();
        if ($tmp != null) {
            $orders = $this->r_orders->get();
        } else {
            $orders = null;
        }
        return $orders;
    }

    protected function getManufacturesAll()
    {
        $manufactures = $this->r_manufactures->get();
        if ($manufactures == null) {
            return null;
        }
        return $manufactures;
    }

    protected function getStocksAll()
    {
        $stocks = $this->r_stocks->get();
        if ($stocks == null) {
            return null;
        }
        return $stocks;
    }

    protected function getTypesAll()
    {
        $types = $this->r_types->get();
        if ($types == null) {
            return null;
        }
        return $types;
    }
}
